/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator;

import com.spacekiller.util.localizator.Extractor;
import com.spacekiller.util.localizator.Localizator;
import com.spacekiller.util.localizator.Property;
import com.spacekiller.util.localizator.StringProperty;
import com.spacekiller.util.localizator.Warning;
import com.spacekiller.util.localizer.NotLocalizable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class AbstractLocalizator
implements Localizator {
    private static final Warning[] NO_WARNINGS = new Warning[0];
    private ResourceBundle bundle;
    private Map<Class, Extractor> extractors = new HashMap<Class, Extractor>();
    private List<Property> properties = new ArrayList<Property>();
    private boolean appendEntries;
    private boolean reorderEntries;
    private boolean remarkMissing;
    private boolean removeMissing;
    private List<Warning> warnings;

    public AbstractLocalizator(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    protected void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public boolean extract(Object o) {
        Extractor x = this.getExtractor(o);
        return x == null ? false : x.extract(o);
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public Property getPropertyAt(int index) {
        return this.properties.get(index);
    }

    @Override
    public Property[] getPropertyArray() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    @Override
    public void appendProperty(String key, String string) {
        this.appendProperty(new StringProperty(key, string));
    }

    @Override
    public void appendProperty(Property p) {
        if (p != null) {
            this.properties.add(p);
        }
    }

    @Override
    public Extractor getExtractor(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof NotLocalizable) {
            return null;
        }
        return this.getExtractorImpl(o.getClass());
    }

    @Override
    public Extractor getExtractor(Class c) {
        if (NotLocalizable.class.isAssignableFrom(c)) {
            return null;
        }
        return this.getExtractorImpl(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Extractor getExtractorImpl(Class c) {
        Map<Class, Extractor> map = this.extractors;
        synchronized (map) {
            while (c != null) {
                Extractor x = this.extractors.get(c);
                if (x != null) {
                    return x;
                }
                c = c.getSuperclass();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExtractor(Class c, Extractor x) throws IllegalArgumentException {
        if (c == null) {
            throw new NullPointerException("Class key is null");
        }
        if (x == null) {
            throw new NullPointerException("Extractor value is null");
        }
        if (NotLocalizable.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class is NotLocalizable: " + c);
        }
        Map<Class, Extractor> map = this.extractors;
        synchronized (map) {
            this.extractors.put(c, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExtractor(Class c, Extractor x) {
        Map<Class, Extractor> map = this.extractors;
        synchronized (map) {
            if (this.extractors.get(c) == x) {
                this.extractors.remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExtractor(Class c) {
        Map<Class, Extractor> map = this.extractors;
        synchronized (map) {
            this.extractors.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllExtractors() {
        Map<Class, Extractor> map = this.extractors;
        synchronized (map) {
            this.extractors.clear();
        }
    }

    public boolean isAppendEntries() {
        return this.appendEntries;
    }

    public void setAppendEntries(boolean appendEntries) {
        this.appendEntries = appendEntries;
    }

    public boolean isReorderEntries() {
        return this.reorderEntries;
    }

    public void setReorderEntries(boolean reorderEntries) {
        this.reorderEntries = reorderEntries;
    }

    public boolean isRemarkMissing() {
        return this.remarkMissing;
    }

    public void setRemarkMissing(boolean remarkMissing) {
        this.remarkMissing = remarkMissing;
    }

    public boolean isRemoveMissing() {
        return this.removeMissing;
    }

    public void setRemoveMissing(boolean removeMissing) {
        this.removeMissing = removeMissing;
    }

    @Override
    public int getWarningCount() {
        List<Warning> list = this.warnings;
        return list == null ? 0 : list.size();
    }

    @Override
    public Warning getWarningAt(int index) {
        return this.warnings.get(index);
    }

    @Override
    public Warning[] getWarningArray() {
        List<Warning> list = this.warnings;
        if (list == null) {
            return NO_WARNINGS;
        }
        return list.toArray(new Warning[list.size()]);
    }

    @Override
    public void appendWarning(Warning warning) {
        if (warning == null) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = new LinkedList<Warning>();
        }
        this.warnings.add(warning);
    }
}

