/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator;

import com.spacekiller.util.localizator.Localizator;
import com.spacekiller.util.localizator.PropertiesFile;
import com.spacekiller.util.localizator.Property;
import com.spacekiller.util.localizator.StringProperty;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalizatorUtil {
    public static final int SORTING_POLICY_DEFAULT = 0;
    public static final int SORTING_POLICY_APPEND = 1;
    public static final int SORTING_POLICY_SORT_NEW_BY_TREE = 2;
    public static final int SORTING_POLICY_SORT_NEW_BY_KEY = 3;
    public static final int SORTING_POLICY_SORT_ALL_BY_TREE = 4;
    public static final int SORTING_POLICY_SORT_ALL_BY_KEY = 5;
    protected static final String SUFFIX_JAVA = ".java";
    protected static final String SUFFIX_PROPERTIES = ".properties";
    private static final Logger logger = Logger.getLogger(LocalizatorUtil.class.getName());
    private boolean dryRun;
    private boolean verbose;
    private boolean insertNewEntries;
    private boolean remarkNewEntries;
    private boolean replaceExistingValues;
    private boolean remarkDuplicateKeys;
    private boolean removeDuplicateKeys;
    private boolean remarkObsoleteEntries;
    private boolean removeObsoleteEntries;
    private int sortingPolicy = 0;
    private int readBufferSize = 65536;
    private byte[] readBuffer;

    public LocalizatorUtil() {
        this.setInsertNewEntries(true);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isInsertNewEntries() {
        return this.insertNewEntries;
    }

    public void setInsertNewEntries(boolean insertNewEntries) {
        this.insertNewEntries = insertNewEntries;
    }

    public boolean isRemarkNewEntries() {
        return this.remarkNewEntries;
    }

    public void setRemarkNewEntries(boolean remarkNewEntries) {
        this.remarkNewEntries = remarkNewEntries;
    }

    public boolean isReplaceExistingValues() {
        return this.replaceExistingValues;
    }

    public void setReplaceExistingValues(boolean replaceExistingValues) {
        this.replaceExistingValues = replaceExistingValues;
    }

    public boolean isRemarkDuplicateKeys() {
        return this.remarkDuplicateKeys;
    }

    public void setRemarkDuplicateKeys(boolean remarkDuplicateKeys) {
        this.remarkDuplicateKeys = remarkDuplicateKeys;
        if (remarkDuplicateKeys) {
            this.removeDuplicateKeys = false;
        }
    }

    public boolean isRemoveDuplicateKeys() {
        return this.removeDuplicateKeys;
    }

    public void setRemoveDuplicateKeys(boolean removeDuplicateKeys) {
        this.removeDuplicateKeys = removeDuplicateKeys;
        if (removeDuplicateKeys) {
            this.remarkDuplicateKeys = false;
        }
    }

    public boolean isRemarkObsoleteEntries() {
        return this.remarkObsoleteEntries;
    }

    public void setRemarkObsoleteEntries(boolean remarkObsoleteEntries) {
        this.remarkObsoleteEntries = remarkObsoleteEntries;
        if (remarkObsoleteEntries) {
            this.removeObsoleteEntries = false;
        }
    }

    public boolean isRemoveObsoleteEntries() {
        return this.removeObsoleteEntries;
    }

    public void setRemoveObsoleteEntries(boolean removeObsoleteEntries) {
        this.removeObsoleteEntries = removeObsoleteEntries;
        if (removeObsoleteEntries) {
            this.remarkObsoleteEntries = false;
        }
    }

    public int getSortingPolicy() {
        return this.sortingPolicy;
    }

    public void setSortingPolicy(int sortingPolicy) {
        this.sortingPolicy = sortingPolicy;
    }

    protected void verbose(String s) {
        if (s == null) {
            return;
        }
        if (this.isVerbose()) {
            logger.info(s);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, s);
        }
    }

    public int exportProperties(Localizator localizator, PropertiesFile propFile) throws IOException {
        String key;
        Property p;
        Property[] props = localizator.getPropertyArray();
        int num = props.length;
        HashMap<String, Integer> key2IndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < num; ++i) {
            p = props[i];
            if (p == null || (key = p.getKey()) == null) continue;
            key2IndexMap.put(key, i);
        }
        int changeCount = 0;
        for (int i = 0; i < num; ++i) {
            p = props[i];
            if (p == null || (key = p.getKey()) == null || !(p instanceof StringProperty)) continue;
            changeCount += this.exportStringProperty((StringProperty)p, propFile, key2IndexMap);
        }
        changeCount += this.handleDuplicateEntries(localizator, propFile, this.isRemarkDuplicateKeys(), this.isRemoveDuplicateKeys());
        this.handleSortingPolicy(propFile, this.getSortingPolicy(), key2IndexMap);
        return changeCount += this.handleObsoleteEntries(localizator, propFile, this.isRemarkObsoleteEntries(), this.isRemoveObsoleteEntries());
    }

    protected int exportStringProperty(StringProperty sp, PropertiesFile propFile, Map<String, Integer> key2IndexMap) {
        return this.exportStringProperty(sp.getKey(), sp.getString(), propFile, key2IndexMap);
    }

    protected int exportStringProperty(String key, String value, PropertiesFile propFile, Map<String, Integer> key2IndexMap) {
        boolean comment;
        if (key == null) {
            return 0;
        }
        boolean verbose = this.isVerbose() || logger.isLoggable(Level.FINE);
        boolean dryRun = this.isDryRun();
        PropertiesFile.Entry[] entries = propFile.getEntries(key);
        int entryCount = entries.length;
        PropertiesFile.Entry lastEntry = null;
        PropertiesFile.Entry lastComment = null;
        for (int i = 0; i < entryCount; ++i) {
            PropertiesFile.Entry entry = entries[i];
            if (entry.isComment()) {
                lastComment = entry;
                continue;
            }
            lastEntry = entry;
        }
        if (lastEntry == null) {
            lastEntry = lastComment;
        }
        if (lastEntry == null) {
            int index;
            boolean comment2 = this.isRemarkNewEntries() || value == null;
            switch (this.getSortingPolicy()) {
                case 2: {
                    index = this.computeIndexByOccurrence(key, propFile, key2IndexMap);
                    break;
                }
                case 3: {
                    index = this.computeIndexByKey(key, propFile);
                    break;
                }
                default: {
                    index = propFile.getEntryCount();
                }
            }
            if (verbose) {
                this.verbose("Inserting entry: key=" + key + ", value=" + value + ", comment=" + comment2);
            }
            if (!dryRun) {
                propFile.insertEntry(index, key, value, comment2);
            }
            return 1;
        }
        String oldValue = lastEntry.getValue();
        if (value == null) {
            if (lastEntry.isComment() && oldValue == null) {
                return 0;
            }
            if (!this.isReplaceExistingValues()) {
                return 0;
            }
            comment = true;
        } else {
            if (!lastEntry.isComment() && value.equals(oldValue)) {
                return 0;
            }
            if (!this.isReplaceExistingValues()) {
                return 0;
            }
            comment = false;
        }
        if (verbose) {
            this.verbose("Updating entry: key=" + key + ", value=" + value + ", comment=" + comment);
        }
        if (!dryRun) {
            propFile.updateEntry(lastEntry, key, value, comment);
        }
        return 1;
    }

    protected int computeIndexByKey(String key, PropertiesFile propFile) {
        int num = propFile.getEntryCount();
        int index = -1;
        for (int i = 0; i < num; ++i) {
            PropertiesFile.Entry entry = propFile.getEntryAt(i);
            String k = entry.getKey();
            if (k != null && key != null && k.compareToIgnoreCase(key) >= 1) {
                index = i;
                break;
            }
            index = i + 1;
        }
        if (index < 0) {
            index = num;
        }
        return index;
    }

    protected int computeIndexByOccurrence(String key, PropertiesFile propFile, Map<String, Integer> key2IndexMap) {
        int index = -1;
        int num = propFile.getEntryCount();
        Integer keyIndex = key2IndexMap.get(key);
        if (keyIndex != null) {
            for (int i = 0; i < num; ++i) {
                PropertiesFile.Entry entry = propFile.getEntryAt(i);
                String k = entry.getKey();
                Integer kIndex = key2IndexMap.get(k);
                if (kIndex != null && kIndex >= keyIndex) {
                    index = i;
                    break;
                }
                index = i + 1;
            }
        }
        if (index < 0) {
            index = num;
        }
        return index;
    }

    protected int handleDuplicateEntries(Localizator localizator, PropertiesFile propFile, boolean remarkDuplicateKeys, boolean removeDuplicateKeys) {
        PropertiesFile.Entry entry;
        boolean verbose = this.isVerbose() || logger.isLoggable(Level.FINE);
        boolean dryRun = this.isDryRun();
        if (!remarkDuplicateKeys && !removeDuplicateKeys) {
            return 0;
        }
        int entryCount = propFile.getEntryCount();
        HashSet<PropertiesFile.Entry> duplicateSet = new HashSet<PropertiesFile.Entry>();
        LinkedList<PropertiesFile.Entry> duplicateList = new LinkedList<PropertiesFile.Entry>();
        for (int i = 0; i < entryCount; ++i) {
            PropertiesFile.Entry dup;
            int k;
            PropertiesFile.Entry[] entries;
            entry = propFile.getEntryAt(i);
            String key = entry.getKey();
            if (key == null || remarkDuplicateKeys && entry.isComment() || (entries = propFile.getEntries(key)).length < 2) continue;
            PropertiesFile.Entry lastEntry = null;
            PropertiesFile.Entry lastComment = null;
            for (k = 0; k < entries.length; ++k) {
                dup = entries[k];
                if (dup == null) continue;
                if (dup.isComment()) {
                    lastComment = dup;
                    continue;
                }
                lastEntry = dup;
            }
            if (lastEntry == null) {
                lastEntry = lastComment;
            }
            for (k = 0; k < entries.length; ++k) {
                dup = entries[k];
                if (dup == null || remarkDuplicateKeys && dup.isComment() || dup == lastEntry || !duplicateSet.add(dup)) continue;
                duplicateList.add(dup);
            }
        }
        int changeCount = 0;
        int duplicateCount = duplicateList.size();
        if (verbose) {
            this.verbose("Number of duplicate entries: " + duplicateCount);
        }
        for (int i = 0; i < duplicateCount; ++i) {
            entry = (PropertiesFile.Entry)duplicateList.get(i);
            if (removeDuplicateKeys) {
                if (verbose) {
                    this.verbose("Removing duplicate entry: " + entry);
                }
                if (!dryRun) {
                    propFile.removeEntry(entry);
                }
                ++changeCount;
                continue;
            }
            if (!remarkDuplicateKeys || entry.isComment()) continue;
            if (verbose) {
                this.verbose("Remarking duplicate entry: " + entry);
            }
            if (!dryRun) {
                propFile.updateEntry(entry, entry.getKey(), entry.getValue(), true);
            }
            ++changeCount;
        }
        return changeCount;
    }

    protected int handleObsoleteEntries(Localizator localizator, PropertiesFile propFile, boolean remarkObsoleteEntries, boolean removeObsoleteEntries) {
        PropertiesFile.Entry entry;
        String key;
        boolean verbose = this.isVerbose() || logger.isLoggable(Level.FINE);
        boolean dryRun = this.isDryRun();
        if (!remarkObsoleteEntries && !removeObsoleteEntries) {
            return 0;
        }
        HashSet<String> keySet = new HashSet<String>();
        for (Property p : localizator.getPropertyArray()) {
            if (p == null || (key = p.getKey()) == null) continue;
            keySet.add(key);
        }
        int entryCount = propFile.getEntryCount();
        LinkedList<PropertiesFile.Entry> obsoleteList = new LinkedList<PropertiesFile.Entry>();
        for (int i = 0; i < entryCount; ++i) {
            entry = propFile.getEntryAt(i);
            key = entry.getKey();
            if (key == null || remarkObsoleteEntries && entry.isComment() || keySet.contains(key)) continue;
            obsoleteList.add(entry);
        }
        int changeCount = 0;
        int obsoleteCount = obsoleteList.size();
        if (verbose) {
            this.verbose("Number of obsolete entries: " + obsoleteCount);
        }
        for (int i = 0; i < obsoleteCount; ++i) {
            entry = (PropertiesFile.Entry)obsoleteList.get(i);
            if (removeObsoleteEntries) {
                if (verbose) {
                    this.verbose("Removing obsolete entry: " + entry);
                }
                if (!dryRun) {
                    propFile.removeEntry(entry);
                }
                ++changeCount;
                continue;
            }
            if (!remarkObsoleteEntries || entry.isComment()) continue;
            if (verbose) {
                this.verbose("Remarking obsolete entry: " + entry);
            }
            if (!dryRun) {
                propFile.updateEntry(entry, entry.getKey(), entry.getValue(), true);
            }
            ++changeCount;
        }
        return changeCount;
    }

    protected void handleSortingPolicy(PropertiesFile propFile, int policy, Map<String, Integer> key2IndexMap) {
        switch (policy) {
            case 4: {
                this.sortAllByOccurrence(propFile, key2IndexMap);
                return;
            }
            case 5: {
                this.sortAllByKey(propFile);
                return;
            }
        }
    }

    protected void sortAllByKey(PropertiesFile propFile) {
        int num = propFile.getEntryCount();
        PropertiesFile sortedProps = new PropertiesFile();
        for (int i = 0; i < num; ++i) {
            PropertiesFile.Entry entry = propFile.getEntryAt(i);
            String key = entry.getKey();
            int index = this.computeIndexByKey(key, sortedProps);
            sortedProps.insertEntry(index, entry);
        }
        this.rebuildPropertiesFile(sortedProps, propFile);
    }

    protected void sortAllByOccurrence(PropertiesFile propFile, Map<String, Integer> key2IndexMap) {
        int num = propFile.getEntryCount();
        PropertiesFile sortedProps = new PropertiesFile();
        for (int i = 0; i < num; ++i) {
            PropertiesFile.Entry entry = propFile.getEntryAt(i);
            String key = entry.getKey();
            int index = this.computeIndexByOccurrence(key, sortedProps, key2IndexMap);
            sortedProps.insertEntry(index, entry);
        }
        this.rebuildPropertiesFile(sortedProps, propFile);
    }

    protected void rebuildPropertiesFile(PropertiesFile sortedProps, PropertiesFile propFile) {
        propFile.removeAllEntries();
        int sortedCount = sortedProps.getEntryCount();
        for (int i = 0; i < sortedCount; ++i) {
            PropertiesFile.Entry sortedEntry = sortedProps.getEntryAt(i);
            propFile.addEntry(sortedEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int updatePropertiesFile(Localizator localizator, File propFile) throws IOException {
        boolean changed;
        byte[] data;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Updating properties file: " + propFile);
        }
        PropertiesFile pf = new PropertiesFile();
        if (propFile.exists()) {
            FileInputStream fis = new FileInputStream(propFile);
            try {
                pf.load(fis);
            }
            finally {
                fis.close();
            }
        }
        int changeCount = this.exportProperties(localizator, pf);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Updated properties file: " + propFile + ", changes=" + changeCount);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            pf.store(baos);
            baos.flush();
            data = baos.toByteArray();
        }
        finally {
            baos.close();
        }
        boolean bl = changed = changeCount > 0;
        if (!changed) {
            if (propFile.exists()) {
                if (propFile.length() == (long)data.length) {
                    byte[] oldData = this.readFile(propFile);
                    if (!Arrays.equals(data, oldData)) {
                        changed = true;
                    }
                } else {
                    changed = true;
                }
            } else {
                changed = true;
            }
        }
        if (changed && !this.isDryRun()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing properties file: " + propFile);
            }
            FileOutputStream fos = new FileOutputStream(propFile);
            try {
                fos.write(data);
            }
            finally {
                fos.close();
            }
        }
        return changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized byte[] readFile(File file) throws IOException {
        byte[] buf = this.readBuffer;
        if (buf == null || buf.length != this.readBufferSize) {
            this.readBuffer = buf = new byte[this.readBufferSize];
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] byArray;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int n;
                while ((n = fis.read(buf)) >= 0) {
                    baos.write(buf, 0, n);
                }
                baos.flush();
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                baos.close();
                throw throwable;
            }
            baos.close();
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    protected int getReadBufferSize() {
        return this.readBufferSize;
    }

    protected void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int updateResourceBundle(Localizator localizator, File baseFile) throws IOException {
        if (!baseFile.exists() || !baseFile.isFile()) {
            throw new IOException("Base file of resource bundle not found: " + baseFile);
        }
        LinkedList<File> propFiles = new LinkedList<File>();
        propFiles.add(baseFile);
        String baseName = baseFile.getName();
        if (baseName.endsWith(SUFFIX_PROPERTIES)) {
            String prefix = baseName.substring(0, baseName.length() - SUFFIX_PROPERTIES.length()) + "_";
            File parentDir = baseFile.getParentFile();
            File[] files = parentDir == null ? null : parentDir.listFiles();
            int num = files == null ? 0 : files.length;
            for (int i = 0; i < num; ++i) {
                String fileName;
                File file = files[i];
                if (file == null || !file.isFile() || !(fileName = file.getName()).endsWith(SUFFIX_PROPERTIES) || !fileName.startsWith(prefix)) continue;
                propFiles.add(file);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Updating properties file(s): " + propFiles.size());
        }
        boolean wasReplaceExistingValues = this.isReplaceExistingValues();
        try {
            int changeCount = 0;
            for (File propFile : propFiles) {
                changeCount += this.updatePropertiesFile(localizator, propFile);
                this.setReplaceExistingValues(false);
            }
            int n = changeCount;
            return n;
        }
        finally {
            if (wasReplaceExistingValues) {
                this.setReplaceExistingValues(true);
            }
        }
    }

    public int updateResourceBundle(Localizator localizator, Class clazz) throws IOException {
        File baseFile = this.findBundleBaseFile(clazz);
        if (baseFile == null) {
            throw new IOException("Base file of resource bundle not found for class: " + clazz.getName());
        }
        return this.updateResourceBundle(localizator, baseFile);
    }

    public File findBundleBaseFile(Class clazz) throws IOException {
        ProtectionDomain domain = clazz.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource source = domain.getCodeSource();
        if (source == null) {
            return null;
        }
        URL location = source.getLocation();
        try {
            File codeDir = LocalizatorUtil.getURLFile(location);
            if (codeDir == null) {
                return null;
            }
            return this.findBundleBaseFile(codeDir, clazz);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public File findBundleBaseFile(File codeDir, Class clazz) throws IOException {
        String classBasePath = clazz.getName().replace('.', '/');
        File javaFile = new File(codeDir, classBasePath + SUFFIX_JAVA);
        File propFile = null;
        if (javaFile.exists() && javaFile.isFile() && (propFile = new File(codeDir, classBasePath + SUFFIX_PROPERTIES)).exists() && propFile.isFile()) {
            return propFile;
        }
        File extendedFile = this.findBundleBaseFileExtended(codeDir, clazz);
        if (extendedFile != null) {
            return extendedFile;
        }
        if (propFile != null) {
            return propFile;
        }
        return null;
    }

    protected File findBundleBaseFileExtended(File codeDir, Class clazz) throws IOException {
        File baseFile = this.findBundleBaseFileMaven(codeDir, clazz);
        if (baseFile != null) {
            return baseFile;
        }
        return null;
    }

    protected File findBundleBaseFileMaven(File codeDir, Class clazz) throws IOException {
        File targetDir;
        File projectDir = null;
        if (codeDir != null && "classes".equals(codeDir.getName()) && (targetDir = codeDir.getParentFile()) != null && "target".equals(targetDir.getName())) {
            projectDir = targetDir.getParentFile();
        }
        if (projectDir == null) {
            return null;
        }
        File srcDir = new File(projectDir, "src");
        if (srcDir == null || !srcDir.exists() || !srcDir.isDirectory()) {
            return null;
        }
        String classBasePath = clazz.getName().replace('.', '/');
        File mainJavaJavaFile = new File(srcDir, "main/java/" + classBasePath + SUFFIX_JAVA);
        File mainJavaPropFile = new File(srcDir, "main/java/" + classBasePath + SUFFIX_PROPERTIES);
        File mainResPropFile = new File(srcDir, "main/resources/" + classBasePath + SUFFIX_PROPERTIES);
        File testJavaJavaFile = new File(srcDir, "test/java/" + classBasePath + SUFFIX_JAVA);
        File testJavaPropFile = new File(srcDir, "test/java/" + classBasePath + SUFFIX_PROPERTIES);
        File testResPropFile = new File(srcDir, "test/resources/" + classBasePath + SUFFIX_PROPERTIES);
        if (mainJavaJavaFile.exists() && mainResPropFile.exists()) {
            return mainResPropFile;
        }
        if (testJavaJavaFile.exists() && testResPropFile.exists()) {
            return testResPropFile;
        }
        if (mainJavaJavaFile.exists() && mainJavaPropFile.exists()) {
            return mainJavaPropFile;
        }
        if (testJavaJavaFile.exists() && testJavaPropFile.exists()) {
            return testJavaPropFile;
        }
        if (mainResPropFile.exists()) {
            return mainResPropFile;
        }
        if (testResPropFile.exists()) {
            return testResPropFile;
        }
        if (mainJavaPropFile.exists()) {
            return mainJavaPropFile;
        }
        if (testJavaPropFile.exists()) {
            return testJavaPropFile;
        }
        return mainResPropFile;
    }

    private static File getURLFile(URL fileURL) throws Exception {
        if (fileURL == null) {
            return null;
        }
        if ("file".equals(fileURL.getProtocol())) {
            String path = fileURL.getPath();
            path = URLDecoder.decode(path, "UTF-8");
            File file = new File(path);
            return file;
        }
        return null;
    }
}

