/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesFile {
    public static final String DEFAULT_LINE_SEPARATOR = "\n";
    public static final String DEFAULT_KEY_VALUE_SEPARATOR = "=";
    public static final String DEFAULT_COMMENT_PREFIX = "#";
    protected static final byte LF = 10;
    protected static final byte CR = 13;
    protected static final byte BS = 92;
    protected static final byte TB = 9;
    protected static final byte FF = 12;
    protected static final byte SP = 32;
    protected static final byte EQ = 61;
    protected static final byte CL = 58;
    protected static final byte EX = 33;
    protected static final byte XX = 35;
    protected static final Entry[] NO_ENTRIES = new Entry[0];
    protected static final byte[] NO_DATA = new byte[0];
    protected LinkedList<Entry> entryList = new LinkedList();
    protected Map<String, List<Entry>> entryMap = new HashMap<String, List<Entry>>();
    protected String lineSeparator;
    protected byte[] lineSeparatorData;
    protected String keyValueSeparator;
    protected byte[] keyValueSeparatorData;
    protected String commentPrefix;
    protected byte[] commentPrefixData;
    protected char[] carr;
    protected char[] cout;
    protected boolean illegalEncoding;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PropertiesFile() {
        this.setLineSeparator(DEFAULT_LINE_SEPARATOR);
        this.setKeyValueSeparator(DEFAULT_KEY_VALUE_SEPARATOR);
        this.setCommentPrefix(DEFAULT_COMMENT_PREFIX);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        if (lineSeparator == null) {
            throw new NullPointerException("lineSeparator");
        }
        this.lineSeparator = lineSeparator;
        this.lineSeparatorData = lineSeparator.getBytes();
    }

    public String getKeyValueSeparator() {
        return this.keyValueSeparator;
    }

    public void setKeyValueSeparator(String keyValueSeparator) {
        if (keyValueSeparator == null) {
            throw new NullPointerException("keyValueSeparator");
        }
        this.keyValueSeparator = keyValueSeparator;
        this.keyValueSeparatorData = keyValueSeparator.getBytes();
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public void setCommentPrefix(String commentPrefix) {
        if (commentPrefix == null) {
            throw new NullPointerException("commentPrefix");
        }
        this.commentPrefix = commentPrefix;
        this.commentPrefixData = commentPrefix.getBytes();
    }

    public synchronized void checkIntegrity() throws IllegalStateException {
        List<Object> list;
        String key;
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (Entry entry : this.entryList) {
            key = entry.key;
            if (key == null) continue;
            list = (LinkedList<Entry>)map.get(key);
            if (list == null) {
                list = new LinkedList<Entry>();
                map.put(key, list);
            }
            list.add(entry);
        }
        for (Map.Entry<String, List<Entry>> me : this.entryMap.entrySet()) {
            key = me.getKey();
            list = me.getValue();
            if (list == null) {
                throw new IllegalStateException("List is null for key: " + key);
            }
            List list2 = (List)map.remove(key);
            if (list2 == null) {
                throw new IllegalStateException("Invalid list for key: " + key);
            }
            if (((Object)list).equals(list2)) continue;
            throw new IllegalStateException("Invalid entries for key: " + key);
        }
        if (!map.isEmpty()) {
            throw new IllegalStateException("Missing key mappings: " + map);
        }
    }

    public synchronized int getEntryCount() {
        return this.entryList.size();
    }

    public synchronized Entry getEntryAt(int index) {
        return this.entryList.get(index);
    }

    public synchronized int getEntryIndex(Entry entry) {
        return this.entryList.indexOf(entry);
    }

    public synchronized Entry[] getEntries(String key) {
        List<Entry> list = this.entryMap.get(key);
        return list == null ? NO_ENTRIES : list.toArray(new Entry[list.size()]);
    }

    public synchronized String getProperty(String key) {
        List<Entry> list = this.entryMap.get(key);
        if (list == null) {
            return null;
        }
        String val = null;
        for (Entry entry : list) {
            if (entry.comment || (val = entry.value) != null) continue;
            val = "";
        }
        return val;
    }

    public synchronized Properties getProperties() {
        Properties props = new Properties();
        for (Entry entry : this.entryList) {
            String key;
            if (entry.comment || (key = entry.key) == null) continue;
            String val = entry.value;
            if (val == null) {
                val = "";
            }
            props.put(key, val);
        }
        return props;
    }

    public synchronized Entry cloneEntry(Entry entry) {
        Entry clone = new Entry();
        clone.comment = entry.comment;
        clone.key = entry.key;
        clone.keyIllegal = entry.keyIllegal;
        clone.value = entry.value;
        clone.valueIllegal = entry.valueIllegal;
        clone.dataComment = entry.dataComment;
        clone.dataPreKey = this.cloneArray(entry.dataPreKey);
        clone.dataKey = this.cloneArray(entry.dataKey);
        clone.dataPostKey = this.cloneArray(entry.dataPostKey);
        clone.dataSeparator = this.cloneArray(entry.dataSeparator);
        clone.dataPreValue = this.cloneArray(entry.dataPreValue);
        clone.dataValue = this.cloneArray(entry.dataValue);
        clone.dataPostValue = this.cloneArray(entry.dataPostValue);
        clone.dataValid = entry.dataValid;
        return clone;
    }

    private byte[] cloneArray(byte[] arr) {
        if (arr == null) {
            return null;
        }
        int len = arr.length;
        byte[] clone = new byte[len];
        System.arraycopy(arr, 0, clone, 0, len);
        return clone;
    }

    public synchronized Entry removeEntryAt(int index) {
        List<Entry> list;
        String key;
        Entry entry = this.entryList.remove(index);
        if (entry != null && (key = entry.key) != null && (list = this.entryMap.get(key)) != null) {
            list.remove(entry);
            if (list.isEmpty()) {
                this.entryMap.remove(key);
            }
        }
        return entry;
    }

    public synchronized boolean removeEntry(Entry entry) {
        int index = this.entryList.indexOf(entry);
        if (index < 0) {
            return false;
        }
        this.removeEntryAt(index);
        return true;
    }

    public synchronized int removeEntries(String key) {
        List<Entry> list = this.entryMap.remove(key);
        if (list == null) {
            return 0;
        }
        this.entryList.removeAll(list);
        return list.size();
    }

    public synchronized void removeAllEntries() {
        this.entryMap.clear();
        this.entryList.clear();
    }

    protected synchronized void appendEntryInternal(Entry entry) {
        this.entryList.add(entry);
        String key = entry.key;
        if (key != null) {
            List<Entry> list = this.entryMap.get(key);
            if (list == null) {
                list = new LinkedList<Entry>();
                this.entryMap.put(key, list);
            }
            list.add(entry);
        }
    }

    public synchronized void appendEntry(Entry entry) {
        this.appendEntryInternal(this.cloneEntry(entry));
    }

    public synchronized void addEntry(Entry entry) {
        this.appendEntryInternal(this.cloneEntry(entry));
    }

    public synchronized Entry addEntry(String key, String value) {
        return this.addEntry(key, value, false);
    }

    public synchronized Entry addEntry(String key, String value, boolean comment) {
        Entry entry = new Entry();
        entry.key = key;
        entry.value = value;
        entry.comment = comment;
        this.appendEntryInternal(entry);
        return entry;
    }

    public synchronized Entry putEntry(String key, String value) {
        return this.putEntry(key, value, false);
    }

    public synchronized Entry putEntry(String key, String value, boolean comment) {
        List<Entry> list = this.entryMap.get(key);
        if (list != null) {
            Entry entry = null;
            Iterator<Entry> i$ = list.iterator();
            while (i$.hasNext()) {
                Entry x;
                entry = x = i$.next();
            }
            if (entry != null) {
                this.updateEntry(entry, key, value, comment);
                return entry;
            }
        }
        return this.addEntry(key, value, comment);
    }

    public synchronized boolean updateEntry(Entry entry, String key, String value, boolean comment) {
        int index = this.getEntryIndex(entry);
        if (index < 0) {
            return false;
        }
        if (comment != entry.comment) {
            entry.dataValid = false;
            entry.comment = comment;
        }
        if (entry.valueIllegal || (value == null ? value != entry.value : !value.equals(entry.value))) {
            entry.dataValid = false;
            entry.value = value;
            entry.valueIllegal = false;
        }
        if (entry.keyIllegal || (key == null ? key != entry.key : !key.equals(entry.key))) {
            this.removeEntryAt(index);
            entry.dataValid = false;
            entry.key = key;
            entry.keyIllegal = false;
            this.insertEntryInternal(entry, index);
        }
        return true;
    }

    public synchronized String setProperty(String key, String value) {
        String prev = this.getProperty(key);
        this.putEntry(key, value);
        return prev;
    }

    protected synchronized void insertEntryInternal(Entry entry, int index) {
        this.entryList.add(index, entry);
        String key = entry.key;
        if (key != null) {
            List<Entry> list = this.entryMap.get(key);
            if (list == null) {
                list = new LinkedList<Entry>();
                this.entryMap.put(key, list);
            }
            if (list.isEmpty()) {
                list.add(entry);
            } else {
                list.clear();
                for (Entry x : this.entryList) {
                    if (!key.equals(x.key)) continue;
                    list.add(x);
                }
            }
        }
    }

    public synchronized void insertEntry(int index, Entry entry) {
        this.insertEntryInternal(this.cloneEntry(entry), index);
    }

    public synchronized Entry insertEntry(int index, String key, String value) {
        return this.insertEntry(index, key, value, false);
    }

    public synchronized Entry insertEntry(int index, String key, String value, boolean comment) {
        Entry entry = new Entry();
        entry.key = key;
        entry.value = value;
        entry.comment = comment;
        this.insertEntryInternal(entry, index);
        return entry;
    }

    public synchronized void formatEntryAt(int index) {
        this.formatEntry(this.getEntryAt(index), this.createStringBuffer());
    }

    public synchronized void formatAllEntries() {
        if (this.entryList.isEmpty()) {
            return;
        }
        StringBuffer sb = this.createStringBuffer();
        for (Entry entry : this.entryList) {
            this.formatEntry(entry, sb);
        }
    }

    protected synchronized void formatEntry(Entry entry, StringBuffer sb) {
        entry.dataValid = false;
        entry.dataComment = false;
        entry.dataPreKey = null;
        entry.dataPostKey = null;
        entry.dataSeparator = null;
        entry.dataPreValue = null;
        entry.dataPostValue = null;
        this.buildEntry(entry, sb);
    }

    protected StringBuffer createStringBuffer() {
        return new StringBuffer(256);
    }

    protected synchronized void buildEntry(Entry entry, StringBuffer sb) {
        String key = entry.key;
        String value = entry.value;
        boolean comment = entry.comment;
        if (!entry.dataValid) {
            entry.dataPreKey = comment ? this.addCommentPrefix(entry.dataPreKey) : this.removeCommentPrefix(entry.dataPreKey);
            byte[] dataKey = entry.dataKey;
            if (key != null) {
                sb.delete(0, sb.length());
                this.saveConvert(key, true, sb);
                dataKey = sb.toString().getBytes();
            } else {
                dataKey = NO_DATA;
            }
            entry.dataKey = dataKey;
            entry.keyIllegal = false;
            if (entry.dataPostKey == null) {
                entry.dataPostKey = NO_DATA;
            }
            if (value != null && value.length() > 0 || key != null && key.length() < 1) {
                if (entry.dataSeparator == null || entry.dataSeparator.length < 1) {
                    entry.dataSeparator = this.keyValueSeparatorData;
                }
            } else {
                entry.dataSeparator = NO_DATA;
            }
            if (entry.dataPreValue == null) {
                entry.dataPreValue = NO_DATA;
            }
            byte[] dataValue = entry.dataValue;
            if (value != null) {
                sb.delete(0, sb.length());
                this.saveConvert(value, false, sb);
                dataValue = sb.toString().getBytes();
            } else {
                dataValue = NO_DATA;
            }
            entry.dataValue = dataValue;
            entry.valueIllegal = false;
            if (entry.dataPostValue == null) {
                entry.dataPostValue = this.lineSeparatorData;
            }
            entry.dataValid = true;
        }
    }

    protected byte[] addCommentPrefix(byte[] data) {
        int n = data == null ? 0 : data.length;
        for (int i = 0; i < n; ++i) {
            switch (data[i]) {
                case 33: 
                case 35: {
                    return data;
                }
            }
        }
        byte[] sep = this.commentPrefixData;
        byte[] arr = new byte[n + sep.length];
        System.arraycopy(sep, 0, arr, 0, sep.length);
        if (n > 0) {
            System.arraycopy(data, 0, arr, sep.length, n);
        }
        return arr;
    }

    protected byte[] removeCommentPrefix(byte[] data) {
        if (data == null) {
            return NO_DATA;
        }
        int n = data.length;
        block3: for (int i = 0; i < n; ++i) {
            switch (data[i]) {
                case 33: 
                case 35: {
                    System.arraycopy(data, i + 1, data, i, n - i - 1);
                    --i;
                    --n;
                    continue block3;
                }
            }
        }
        if (n != data.length) {
            byte[] arr = new byte[n];
            System.arraycopy(data, 0, arr, 0, n);
            data = arr;
        }
        return data;
    }

    public synchronized void store(OutputStream out) throws IOException {
        if (this.entryList.isEmpty()) {
            return;
        }
        StringBuffer sb = null;
        boolean wasLineSep = true;
        for (Entry entry : this.entryList) {
            if (!wasLineSep) {
                out.write(this.lineSeparatorData);
            }
            if (!entry.dataValid) {
                if (sb == null) {
                    sb = this.createStringBuffer();
                }
                this.buildEntry(entry, sb);
            }
            out.write(entry.dataPreKey);
            out.write(entry.dataKey);
            out.write(entry.dataPostKey);
            out.write(entry.dataSeparator);
            out.write(entry.dataPreValue);
            out.write(entry.dataValue);
            out.write(entry.dataPostValue);
            wasLineSep = entry.dataPostValue.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream inStream) throws IOException {
        try {
            this.carr = new char[1024];
            this.cout = new char[1024];
            this.load(inStream, new byte[8192]);
        }
        finally {
            this.carr = null;
            this.cout = null;
        }
    }

    protected synchronized void load(InputStream inStream, byte[] buf) throws IOException {
        int off = 0;
        int len = 0;
        byte[] data = new byte[1024];
        int dataOff = 0;
        boolean wasLF = false;
        boolean wasCR = false;
        boolean escape = false;
        boolean skipLF = false;
        block5: while (true) {
            if (off >= len) {
                len = inStream.read(buf);
                off = 0;
                if (len <= 0) {
                    this.parseEntry(data, 0, dataOff);
                    dataOff = 0;
                    wasLF = false;
                    wasCR = false;
                    escape = false;
                    return;
                }
            }
            byte b = buf[off++];
            if (dataOff >= data.length) {
                byte[] arr = new byte[dataOff * 2];
                System.arraycopy(data, 0, arr, 0, dataOff);
                data = arr;
            }
            switch (b) {
                case 10: {
                    if (wasLF && !skipLF) {
                        this.parseEntry(data, 0, dataOff);
                        dataOff = 0;
                    }
                    data[dataOff++] = b;
                    wasLF = true;
                    wasCR = false;
                    escape = false;
                    continue block5;
                }
                case 13: {
                    if (wasLF && !skipLF) {
                        this.parseEntry(data, 0, dataOff);
                        dataOff = 0;
                    }
                    data[dataOff++] = b;
                    wasCR = true;
                    wasLF = false;
                    escape = false;
                    continue block5;
                }
                case 92: {
                    if (wasLF || wasCR) {
                        this.parseEntry(data, 0, dataOff);
                        dataOff = 0;
                        wasLF = false;
                        wasCR = false;
                        escape = false;
                    }
                    data[dataOff++] = b;
                    skipLF = escape = !escape;
                    continue block5;
                }
            }
            if (skipLF) {
                skipLF = false;
                wasLF = false;
                wasCR = false;
            } else if (wasLF || wasCR) {
                this.parseEntry(data, 0, dataOff);
                dataOff = 0;
                wasLF = false;
                wasCR = false;
            }
            data[dataOff++] = b;
            escape = false;
        }
    }

    protected synchronized void parseEntry(byte[] data, int off, int end) {
        if (off >= end) {
            return;
        }
        boolean comment = false;
        boolean escape = false;
        int sepOfs = -1;
        int keyOfs = -1;
        int keyEnd = -1;
        boolean keyIllegal = false;
        int valOfs = -1;
        int valEnd = -1;
        boolean valIllegal = false;
        block7: for (int i = off; i < end; ++i) {
            byte b = data[i];
            switch (b) {
                case 10: 
                case 13: {
                    escape = false;
                    continue block7;
                }
                case 92: {
                    escape = !escape;
                    break;
                }
                case 58: 
                case 61: {
                    if (!escape) {
                        sepOfs = i;
                        continue block7;
                    }
                    escape = false;
                    break;
                }
                case 33: 
                case 35: {
                    if (!escape && keyOfs < 0) {
                        comment = true;
                        continue block7;
                    }
                    escape = false;
                    break;
                }
                case 9: 
                case 12: 
                case 32: {
                    if (!escape && (keyOfs < 0 || valEnd < 0 && valOfs < 0)) continue block7;
                    escape = false;
                    break;
                }
                default: {
                    escape = false;
                }
            }
            if (keyOfs < 0 && sepOfs < 0) {
                keyOfs = i;
                keyEnd = i + 1;
                continue;
            }
            if (sepOfs < 0) {
                keyEnd = i + 1;
                continue;
            }
            if (valOfs < 0) {
                valOfs = i;
                valEnd = i + 1;
                continue;
            }
            valEnd = i + 1;
        }
        String key = this.parseString(data, keyOfs, keyEnd);
        keyIllegal = this.illegalEncoding;
        if (key == null && sepOfs >= 0) {
            key = "";
        }
        String value = this.parseString(data, valOfs, valEnd);
        valIllegal = this.illegalEncoding;
        if (!(value != null || key == null || sepOfs < 0 && comment)) {
            value = "";
        }
        Entry entry = new Entry();
        entry.comment = comment;
        entry.key = key;
        entry.keyIllegal = keyIllegal;
        entry.value = value;
        entry.valueIllegal = valIllegal;
        entry.dataPreKey = keyOfs < 0 ? NO_DATA : this.subArray(data, 0, keyOfs);
        entry.dataKey = keyOfs < 0 ? NO_DATA : this.subArray(data, keyOfs, keyEnd);
        entry.dataPostKey = sepOfs < 0 || keyEnd < 0 ? NO_DATA : this.subArray(data, keyEnd, sepOfs);
        entry.dataSeparator = sepOfs < 0 ? NO_DATA : this.subArray(data, sepOfs, sepOfs + 1);
        entry.dataPreValue = sepOfs < 0 ? NO_DATA : this.subArray(data, sepOfs + 1, valOfs);
        entry.dataValue = valOfs < 0 ? NO_DATA : this.subArray(data, valOfs, valEnd);
        int postOfs = Math.max(0, Math.max(keyEnd, Math.max(sepOfs + 1, valEnd)));
        entry.dataPostValue = this.subArray(data, postOfs, end);
        entry.dataValid = true;
        this.appendEntryInternal(entry);
    }

    protected byte[] subArray(byte[] data, int off, int end) {
        if (off >= end) {
            return NO_DATA;
        }
        int len = end - off;
        byte[] arr = new byte[len];
        System.arraycopy(data, off, arr, 0, len);
        return arr;
    }

    protected synchronized String parseString(byte[] data, int off, int end) {
        this.illegalEncoding = false;
        if (off >= end) {
            return null;
        }
        int len = end - off;
        if (this.carr == null || this.carr.length < len) {
            this.carr = new char[len];
        }
        boolean escape = false;
        boolean newLine = true;
        int num = 0;
        block5: for (int i = 0; i < len; ++i) {
            byte b = data[off++];
            switch (b) {
                case 10: 
                case 13: {
                    if (escape && num > 0) {
                        --num;
                    }
                    escape = false;
                    newLine = true;
                    continue block5;
                }
                case 92: {
                    escape = !escape;
                    newLine = false;
                    this.carr[num++] = (char)(b & 0xFF);
                    continue block5;
                }
                case 9: 
                case 12: 
                case 32: {
                    if (newLine) continue block5;
                }
                default: {
                    escape = false;
                    newLine = false;
                    this.carr[num++] = (char)(b & 0xFF);
                }
            }
        }
        return this.loadConvert(this.carr, 0, num);
    }

    protected synchronized String loadConvert(char[] in, int off, int len) {
        this.illegalEncoding = false;
        if (this.cout == null || this.cout.length < len) {
            this.cout = new char[len];
        }
        char[] out = this.cout;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    boolean valid = true;
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                off = off - i - 1;
                                i = 4;
                                valid = false;
                            }
                        }
                    }
                    if (valid) {
                        out[outLen++] = (char)value;
                        continue;
                    }
                    out[outLen++] = 92;
                    out[outLen++] = 117;
                    this.illegalEncoding = true;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    protected void saveConvert(String theString, boolean escapeSpace, StringBuffer outBuffer) {
        int len = theString.length();
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesFile.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public class Entry {
        protected boolean comment;
        protected String key;
        protected boolean keyIllegal = false;
        protected String value;
        protected boolean valueIllegal = false;
        protected boolean dataComment;
        protected byte[] dataPreKey;
        protected byte[] dataKey;
        protected byte[] dataPostKey;
        protected byte[] dataSeparator;
        protected byte[] dataPreValue;
        protected byte[] dataValue;
        protected byte[] dataPostValue;
        protected boolean dataValid = false;

        protected Entry() {
        }

        public boolean isComment() {
            return this.comment;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isKeyIllegal() {
            return this.keyIllegal;
        }

        public boolean isValueIllegal() {
            return this.valueIllegal;
        }

        public String toString() {
            return (this.comment ? PropertiesFile.DEFAULT_COMMENT_PREFIX : "") + String.valueOf(this.key) + PropertiesFile.DEFAULT_KEY_VALUE_SEPARATOR + String.valueOf(this.value);
        }
    }
}

