/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator.swing;

import com.spacekiller.util.localizator.AbstractLocalizator;
import com.spacekiller.util.localizator.Warning;
import com.spacekiller.util.localizator.swing.AmbiguousPropertyWarning;
import com.spacekiller.util.localizator.swing.DuplicateNameWarning;
import com.spacekiller.util.localizator.swing.MissingNameWarning;
import com.spacekiller.util.localizator.swing.SwingLocalizator;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractSwingLocalizator
extends AbstractLocalizator
implements SwingLocalizator {
    private static final Logger logger = Logger.getLogger(AbstractSwingLocalizator.class.getName());
    private Class clazz;
    private Set<Component> missingNameComponents;
    private Map<String, Set<Component>> componentNameMap;
    private Map<String, Set<String>> keyValueMap;
    private boolean includeTexts = true;
    private boolean includeTooltips = true;
    private boolean includeIcons = true;
    private boolean includeBorderTitles = true;
    private boolean includeTabTitles = true;
    private boolean includeTabTooltips = true;
    private boolean includeTabIcons = true;

    public AbstractSwingLocalizator(ResourceBundle bundle, Class clazz) {
        super(bundle);
        this.initAbstractSwingLocalizator(clazz);
    }

    public AbstractSwingLocalizator(Class clazz, Locale locale) {
        super(AbstractSwingLocalizator.loadBundle(clazz, locale));
        this.initAbstractSwingLocalizator(clazz);
    }

    protected void initAbstractSwingLocalizator(Class clazz) {
        this.missingNameComponents = new HashSet<Component>();
        this.componentNameMap = new HashMap<String, Set<Component>>();
        this.keyValueMap = new HashMap<String, Set<String>>();
        this.setClazz(clazz);
    }

    protected static ResourceBundle loadBundle(Class clazz, Locale locale) {
        return ResourceBundle.getBundle(clazz.getName(), locale);
    }

    public Class getClazz() {
        return this.clazz;
    }

    protected void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean appendProperty(Component c, String keySuffix, String string) {
        String key;
        Set<String> valueSet;
        if (c == null) {
            return false;
        }
        String name = c.getName();
        if (name == null) {
            if (this.missingNameComponents.add(c)) {
                this.appendWarning((Warning)new MissingNameWarning(c));
            }
            return false;
        }
        Set<Component> compSet = this.componentNameMap.get(name);
        if (compSet == null) {
            compSet = new HashSet<Component>();
            this.componentNameMap.put(name, compSet);
        }
        if (compSet.add(c) && compSet.size() == 2) {
            this.appendWarning((Warning)new DuplicateNameWarning((Object)c, name));
        }
        if ((valueSet = this.keyValueMap.get(key = this.getKey(c, keySuffix))) == null) {
            valueSet = new HashSet<String>();
            this.keyValueMap.put(key, valueSet);
        }
        if (valueSet.add(string) && valueSet.size() == 2) {
            this.appendWarning((Warning)new AmbiguousPropertyWarning((Object)c, key));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("extract: " + key + " = " + string);
        }
        this.appendProperty(key, string);
        return true;
    }

    @Override
    public String getKey(Component c, String suffix) {
        String name = c.getName();
        if (name == null) {
            return null;
        }
        return name + suffix;
    }

    @Override
    public int getMissingNameComponentCount() {
        Set<Component> set = this.missingNameComponents;
        return set == null ? 0 : set.size();
    }

    @Override
    public Component[] getMissingNameComponents() {
        Set<Component> set = this.missingNameComponents;
        if (set == null) {
            return new Component[0];
        }
        return set.toArray(new Component[set.size()]);
    }

    @Override
    public String[] getDuplicateNames() {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, Set<Component>> me : this.componentNameMap.entrySet()) {
            Set<Component> comps = me.getValue();
            if (comps.size() <= 1) continue;
            list.add(me.getKey());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Component[] getDuplicateNameComponents(String name) {
        Set<Component> comps = this.componentNameMap.get(name);
        return comps.toArray(new Component[comps.size()]);
    }

    @Override
    public String[] getAmbiguousPropertyKeys() {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, Set<String>> me : this.keyValueMap.entrySet()) {
            Set<String> values = me.getValue();
            if (values.size() <= 1) continue;
            list.add(me.getKey());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String[] getAmbiguousPropertyValues(String key) {
        Set<String> values = this.keyValueMap.get(key);
        return values.toArray(new String[values.size()]);
    }

    @Override
    public boolean isIncludeTexts() {
        return this.includeTexts;
    }

    public void setIncludeTexts(boolean includeTexts) {
        this.includeTexts = includeTexts;
    }

    @Override
    public boolean isIncludeTooltips() {
        return this.includeTooltips;
    }

    public void setIncludeTooltips(boolean includeTooltips) {
        this.includeTooltips = includeTooltips;
    }

    @Override
    public boolean isIncludeIcons() {
        return this.includeIcons;
    }

    public void setIncludeIcons(boolean includeIcons) {
        this.includeIcons = includeIcons;
    }

    @Override
    public boolean isIncludeBorderTitles() {
        return this.includeBorderTitles;
    }

    public void setIncludeBorderTitles(boolean includeBorderTitles) {
        this.includeBorderTitles = includeBorderTitles;
    }

    @Override
    public boolean isIncludeTabTitles() {
        return this.includeTabTitles;
    }

    public void setIncludeTabTitles(boolean includeTabTitles) {
        this.includeTabTitles = includeTabTitles;
    }

    @Override
    public boolean isIncludeTabTooltips() {
        return this.includeTabTooltips;
    }

    public void setIncludeTabTooltips(boolean includeTabTooltips) {
        this.includeTabTooltips = includeTabTooltips;
    }

    @Override
    public boolean isIncludeTabIcons() {
        return this.includeTabIcons;
    }

    public void setIncludeTabIcons(boolean includeTabIcons) {
        this.includeTabIcons = includeTabIcons;
    }

    @Override
    public boolean appendIcon(Component c, String keySuffix, Icon icon) {
        return this.appendIcon(c, keySuffix, icon, true);
    }

    @Override
    public boolean appendIcon(Component c, String keySuffix, Icon icon, boolean includeNull) {
        ImageIcon i;
        String descr;
        if (!this.isIncludeIcons()) {
            return false;
        }
        if (icon == null) {
            if (includeNull) {
                this.appendProperty(c, keySuffix, null);
                return true;
            }
            return false;
        }
        if (icon instanceof ImageIcon && (descr = (i = (ImageIcon)icon).getDescription()) != null && descr.length() > 0) {
            try {
                URL url = new URL(descr);
                String path = url.getPath();
                String resourcePath = this.locateResourcePath(path);
                if (resourcePath != null) {
                    this.appendProperty(c, keySuffix, resourcePath);
                    return true;
                }
            }
            catch (MalformedURLException e) {
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return false;
    }

    public String locateResourcePath(String path) {
        if (path == null) {
            return null;
        }
        Class clazz = this.getClazz();
        if (clazz == null) {
            return null;
        }
        String best = null;
        while (path.length() > 0) {
            int x;
            URL res = clazz.getResource(path);
            if (res != null) {
                best = path;
            }
            if ((x = path.indexOf(47)) < 0) break;
            if (x > 0) {
                path = path.substring(x);
                continue;
            }
            path = path.substring(x + 1);
        }
        return best;
    }
}

