/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator.swing;

import com.spacekiller.util.localizator.swing.ComponentExtractor;
import com.spacekiller.util.localizator.swing.SwingLocalizator;
import com.spacekiller.util.localizer.Localizable;
import com.spacekiller.util.localizer.NotLocalizable;
import com.spacekiller.util.localizer.swing.ComponentRefresher;
import java.awt.Component;
import java.awt.Container;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerExtractor
extends ComponentExtractor {
    private static final Logger logger = Logger.getLogger(ContainerExtractor.class.getName());

    public ContainerExtractor(SwingLocalizator localizator) {
        super(localizator);
    }

    @Override
    public boolean extract(Object o) {
        boolean result = super.extract(o);
        return result |= this.extractContainer((Container)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean extractContainer(Container c) {
        boolean result = false;
        Object object = c.getTreeLock();
        synchronized (object) {
            int n = c.getComponentCount();
            for (int i = 0; i < n; ++i) {
                result |= this.extractComponent(c, i, c.getComponent(i));
            }
        }
        return result;
    }

    protected boolean extractComponent(Container c, int i, Component x) {
        if (x instanceof NotLocalizable) {
            return false;
        }
        if (x instanceof Localizable) {
            return false;
        }
        try {
            if (ComponentRefresher.isLocalizable((Component)x)) {
                return this.localizator.extract(x);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }
}

