/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator.swing;

import com.spacekiller.util.localizator.swing.ContainerExtractor;
import com.spacekiller.util.localizator.swing.SwingLocalizator;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class JComponentExtractor
extends ContainerExtractor {
    public JComponentExtractor(SwingLocalizator localizator) {
        super(localizator);
    }

    @Override
    public boolean extract(Object o) {
        boolean result = false;
        JComponent c = (JComponent)o;
        result |= this.extractToolTipText(c);
        result |= this.extractBorderTitle(c);
        return result |= super.extract(o);
    }

    public boolean extractToolTipText(JComponent c) {
        if (!this.localizator.isIncludeTooltips()) {
            return false;
        }
        String tip = c.getToolTipText();
        return this.localizator.appendProperty(c, ".tip", tip);
    }

    public boolean extractBorderTitle(JComponent c) {
        if (!this.localizator.isIncludeBorderTitles()) {
            return false;
        }
        String title = null;
        Border b = c.getBorder();
        if (b != null && b instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)b;
            title = tb.getTitle();
        }
        if (title == null) {
            return false;
        }
        return this.localizator.appendProperty(c, ".border.title", title);
    }
}

