/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator.swing;

import com.spacekiller.util.localizator.swing.JComponentExtractor;
import com.spacekiller.util.localizator.swing.SwingLocalizator;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class JTabbedPaneExtractor
extends JComponentExtractor {
    public JTabbedPaneExtractor(SwingLocalizator localizator) {
        super(localizator);
    }

    @Override
    public boolean extract(Object o) {
        return super.extract(o);
    }

    @Override
    protected boolean extractComponent(Container c, int i, Component x) {
        boolean result = false;
        if (x != null) {
            JTabbedPane tp = (JTabbedPane)c;
            if (this.localizator.isIncludeTabTitles()) {
                String title = tp.getTitleAt(i);
                result |= this.localizator.appendProperty(x, ".tab.title", title);
            }
            if (this.localizator.isIncludeTabTooltips()) {
                String tip = tp.getToolTipTextAt(i);
                result |= this.localizator.appendProperty(x, ".tab.tip", tip);
            }
            if (this.localizator.isIncludeTabIcons()) {
                Icon icon = tp.getIconAt(i);
                result |= this.localizator.appendIcon(x, ".tab.icon", icon);
            }
        }
        return result |= super.extractComponent(c, i, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extractTabs(JTabbedPane c) {
        boolean result = false;
        Object object = c.getTreeLock();
        synchronized (object) {
            int n = c.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component t = c.getComponentAt(i);
                if (t == null) continue;
            }
        }
        return result;
    }
}

