/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizator.swing;

import com.spacekiller.util.localizator.AbstractWarning;
import java.awt.Component;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwingWarning
extends AbstractWarning {
    private Component component;
    private LinkedList<Component> hierarchy;

    public SwingWarning(Object object, String message) {
        super(object, message);
        this.initSwingWarning(object);
    }

    public SwingWarning(Component component, String message) {
        super((Object)component, message);
        this.initSwingWarning(component);
    }

    protected void initSwingWarning(Object object) {
        if (object != null && object instanceof Component) {
            this.initSwingWarning((Component)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSwingWarning(Component component) {
        this.hierarchy = null;
        this.setComponent(component);
        if (component != null) {
            this.hierarchy = new LinkedList();
            Object object = component.getTreeLock();
            synchronized (object) {
                for (Component c = component; c != null; c = c.getParent()) {
                    this.hierarchy.addFirst(c);
                }
            }
        }
    }

    public Component getComponent() {
        return this.component;
    }

    protected void setComponent(Component component) {
        this.component = component;
    }

    public Component[] getComponentHierarchy() {
        LinkedList<Component> list = this.hierarchy;
        if (list == null) {
            return null;
        }
        return list.toArray(new Component[list.size()]);
    }

    public void log(Logger logger, Level level) {
        Component[] arr;
        if (!logger.isLoggable(level)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getMessage()));
        if (logger.isLoggable(Level.FINER) && (arr = this.getComponentHierarchy()) != null) {
            String indent;
            String prefix = indent = "  ";
            for (int i = 0; i < arr.length; ++i) {
                sb.append("\n" + prefix + "- " + arr[i]);
                prefix = prefix + indent;
            }
        }
        logger.log(level, sb.toString());
    }
}

