/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer;

import com.spacekiller.util.localizer.Localizer;
import com.spacekiller.util.localizer.NotLocalizable;
import com.spacekiller.util.localizer.Refresher;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class AbstractLocalizer
implements Localizer {
    private ResourceBundle bundle;
    private Map<Class, Refresher> refreshers = new HashMap<Class, Refresher>();

    public AbstractLocalizer(ResourceBundle bundle) {
        this.setBundle(bundle);
    }

    @Override
    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public boolean containsKey(String key) {
        return key == null ? false : this.bundle.containsKey(key);
    }

    @Override
    public Object getObject(String key) {
        return this.bundle.getObject(key);
    }

    @Override
    public String getString(String key) {
        return this.bundle.getString(key);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.bundle.getStringArray(key);
    }

    @Override
    public boolean refresh(Object o) {
        Refresher r = this.getRefresher(o);
        if (r != null) {
            return r.refresh(o);
        }
        return false;
    }

    @Override
    public Refresher getRefresher(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof NotLocalizable) {
            return null;
        }
        return this.getRefresherImpl(o.getClass());
    }

    @Override
    public Refresher getRefresher(Class c) {
        if (NotLocalizable.class.isAssignableFrom(c)) {
            return null;
        }
        return this.getRefresherImpl(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Refresher getRefresherImpl(Class c) {
        Map<Class, Refresher> map = this.refreshers;
        synchronized (map) {
            while (c != null) {
                Refresher r = this.refreshers.get(c);
                if (r != null) {
                    return r;
                }
                c = c.getSuperclass();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefresher(Class c, Refresher r) throws IllegalArgumentException {
        if (c == null) {
            throw new NullPointerException("Class key is null");
        }
        if (r == null) {
            throw new NullPointerException("Refresher value is null");
        }
        if (NotLocalizable.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class is NotLocalizable: " + c);
        }
        Map<Class, Refresher> map = this.refreshers;
        synchronized (map) {
            this.refreshers.put(c, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefresher(Class c, Refresher r) {
        Map<Class, Refresher> map = this.refreshers;
        synchronized (map) {
            if (this.refreshers.get(c) == r) {
                this.refreshers.remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefresher(Class c) {
        Map<Class, Refresher> map = this.refreshers;
        synchronized (map) {
            this.refreshers.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRefreshers() {
        Map<Class, Refresher> map = this.refreshers;
        synchronized (map) {
            this.refreshers.clear();
        }
    }
}

