/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class LocalizerUtil {
    private static LocalizerUtil INSTANCE;

    protected LocalizerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalizerUtil getInstance() {
        LocalizerUtil instance = INSTANCE;
        if (instance != null) return instance;
        Class<LocalizerUtil> clazz = LocalizerUtil.class;
        synchronized (LocalizerUtil.class) {
            instance = INSTANCE;
            if (instance != null) return instance;
            INSTANCE = instance = new LocalizerUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public List<Locale> enumerateAvailableLocales(Class clazz) throws IOException {
        return this.enumerateAvailableLocales(clazz, clazz.getName());
    }

    public List<Locale> enumerateAvailableLocales(Class clazz, String baseName) throws IOException {
        LinkedList<Locale> localeList = new LinkedList<Locale>();
        String prefix = baseName.replace('.', '/');
        String suffix = ".properties";
        ClassLoader loader = clazz.getClassLoader();
        for (Locale locale : Locale.getAvailableLocales()) {
            String localeString = locale.toString();
            String path = localeString.length() > 0 ? prefix + "_" + localeString + suffix : prefix + localeString + suffix;
            URL url = loader.getResource(path);
            if (url == null) continue;
            localeList.add(locale);
        }
        return localeList;
    }
}

