/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.swing.JComponentRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Container;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;

public class AbstractButtonRefresher
extends JComponentRefresher {
    private static final Logger logger = Logger.getLogger(AbstractButtonRefresher.class.getName());
    public static final String SUFFIX_TEXT = ".text";
    public static final String SUFFIX_ICON = ".icon";

    public AbstractButtonRefresher(SwingLocalizer localizer) {
        super(localizer);
    }

    @Override
    public boolean refresh(Object o) {
        boolean result = false;
        AbstractButton b = (AbstractButton)o;
        result |= this.refreshButtonText(b);
        result |= this.refreshButtonIcon(b);
        return result |= super.refresh(o);
    }

    @Override
    protected boolean refreshContainer(Container c) {
        return false;
    }

    public boolean refreshButtonText(AbstractButton c) {
        String key = this.localizer.getKey(c, SUFFIX_TEXT);
        if (this.localizer.containsKey(key)) {
            String text = this.localizer.getString(key);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("refreshButtonText: " + key + " = " + text);
            }
            if (text != null) {
                c.setText(text);
                return true;
            }
        }
        return false;
    }

    public boolean refreshButtonIcon(AbstractButton c) {
        String key = this.localizer.getKey(c, SUFFIX_ICON);
        if (this.localizer.containsKey(key)) {
            String text = this.localizer.getString(key);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("refreshButtonIcon: " + key + " = " + text);
            }
            if (text != null) {
                c.setIcon(this.localizer.getIcon(text));
                return true;
            }
        }
        return false;
    }
}

