/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.swing.ComponentRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Button;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ButtonRefresher
extends ComponentRefresher {
    private static final Logger logger = Logger.getLogger(ButtonRefresher.class.getName());
    public static final String SUFFIX_TEXT = ".text";

    public ButtonRefresher(SwingLocalizer localizer) {
        super(localizer);
    }

    @Override
    public boolean refresh(Object o) {
        boolean result = false;
        Button b = (Button)o;
        result |= this.refreshButtonText(b);
        return result |= super.refresh(o);
    }

    public boolean refreshButtonText(Button c) {
        String key = this.localizer.getKey(c, SUFFIX_TEXT);
        if (this.localizer.containsKey(key)) {
            String text = this.localizer.getString(key);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("refreshButtonText: " + key + " = " + text);
            }
            if (text != null) {
                c.setLabel(text);
                return true;
            }
        }
        return false;
    }
}

