/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.Localizable;
import com.spacekiller.util.localizer.Localizer;
import com.spacekiller.util.localizer.NotLocalizable;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

public class ContainerHandler
implements ContainerListener {
    protected Container container;
    protected Localizer localizer;

    public ContainerHandler(Container container) {
        this.setContainer(container);
    }

    public ContainerHandler(Container container, Localizer localizer) {
        this(container);
        this.setLocalizer(localizer);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Localizer l;
        Component child = e.getChild();
        if (child == null) {
            return;
        }
        if (child instanceof NotLocalizable) {
            return;
        }
        if (child instanceof Localizable) {
            return;
        }
        if (child instanceof Container) {
            this.containerAdded((Container)child);
        }
        if ((l = this.localizer) != null) {
            l.refresh((Object)child);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component child = e.getChild();
        if (child != null && child instanceof Container) {
            this.containerRemoved((Container)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void containerAdded(Container c) {
        Object object = c.getTreeLock();
        synchronized (object) {
            c.removeContainerListener(this);
            c.addContainerListener(this);
            int n = c.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component comp = c.getComponent(i);
                if (comp == null || !(comp instanceof Container)) continue;
                this.containerAdded((Container)comp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void containerRemoved(Container c) {
        Object object = c.getTreeLock();
        synchronized (object) {
            c.removeContainerListener(this);
            int n = c.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component comp = c.getComponent(i);
                if (comp == null || !(comp instanceof Container)) continue;
                this.containerRemoved((Container)comp);
            }
        }
    }

    public synchronized Container getContainer() {
        return this.container;
    }

    public synchronized void setContainer(Container container) {
        Container old = this.container;
        if (old == container) {
            return;
        }
        if (old != null) {
            this.containerRemoved(old);
        }
        this.container = container;
        if (container != null) {
            this.containerAdded(container);
        }
    }

    public synchronized Localizer getLocalizer() {
        return this.localizer;
    }

    public synchronized void setLocalizer(Localizer localizer) {
        this.localizer = localizer;
        localizer.refresh((Object)this.container);
    }
}

