/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.Localizable;
import com.spacekiller.util.localizer.NotLocalizable;
import com.spacekiller.util.localizer.swing.ComponentRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Component;
import java.awt.Container;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerRefresher
extends ComponentRefresher {
    private static final Logger logger = Logger.getLogger(ContainerRefresher.class.getName());

    public ContainerRefresher(SwingLocalizer localizer) {
        super(localizer);
    }

    @Override
    public boolean refresh(Object o) {
        boolean result = false;
        return result |= this.refreshContainer((Container)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshContainer(Container c) {
        boolean result = false;
        Object object = c.getTreeLock();
        synchronized (object) {
            int n = c.getComponentCount();
            for (int i = 0; i < n; ++i) {
                result |= this.refreshComponent(c, i, c.getComponent(i));
            }
        }
        return result;
    }

    protected boolean refreshComponent(Container c, int i, Component x) {
        if (x instanceof NotLocalizable) {
            return false;
        }
        if (x instanceof Localizable) {
            return false;
        }
        try {
            if (ContainerRefresher.isLocalizable(x)) {
                return this.localizer.refresh(x);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }
}

