/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.AbstractLocalizer;
import com.spacekiller.util.localizer.swing.AbstractButtonRefresher;
import com.spacekiller.util.localizer.swing.ButtonRefresher;
import com.spacekiller.util.localizer.swing.ComponentRefresher;
import com.spacekiller.util.localizer.swing.ContainerRefresher;
import com.spacekiller.util.localizer.swing.JComboBoxRefresher;
import com.spacekiller.util.localizer.swing.JComponentRefresher;
import com.spacekiller.util.localizer.swing.JLabelRefresher;
import com.spacekiller.util.localizer.swing.JPanelRefresher;
import com.spacekiller.util.localizer.swing.JTabbedPaneRefresher;
import com.spacekiller.util.localizer.swing.JViewportRefresher;
import com.spacekiller.util.localizer.swing.LabelRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class DefaultSwingLocalizer
extends AbstractLocalizer
implements SwingLocalizer {
    private static final Logger logger = Logger.getLogger(DefaultSwingLocalizer.class.getName());
    private Class clazz;
    private Map<String, Icon> iconCache = new HashMap<String, Icon>();

    public DefaultSwingLocalizer(Class clazz, ResourceBundle bundle) {
        super(bundle);
        this.setClazz(clazz);
        this.addDefaultRefreshers();
    }

    public DefaultSwingLocalizer(Class clazz, Locale locale) throws MissingResourceException {
        this(clazz, DefaultSwingLocalizer.loadBundle(clazz, locale));
    }

    protected static ResourceBundle loadBundle(Class clazz, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(clazz.getName(), locale);
    }

    protected void addDefaultRefreshers() {
        this.addRefresher(Component.class, new ComponentRefresher(this));
        this.addRefresher(Container.class, new ContainerRefresher(this));
        this.addRefresher(Button.class, new ButtonRefresher(this));
        this.addRefresher(Label.class, new LabelRefresher(this));
        this.addRefresher(JComponent.class, new JComponentRefresher(this));
        this.addRefresher(JPanel.class, new JPanelRefresher(this));
        this.addRefresher(JTabbedPane.class, new JTabbedPaneRefresher(this));
        this.addRefresher(JViewport.class, new JViewportRefresher(this));
        this.addRefresher(AbstractButton.class, new AbstractButtonRefresher(this));
        this.addRefresher(JLabel.class, new JLabelRefresher(this));
        this.addRefresher(JComboBox.class, new JComboBoxRefresher(this));
    }

    public Class getClazz() {
        return this.clazz;
    }

    protected void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public void setBundle(ResourceBundle bundle) {
        super.setBundle(bundle);
        this.clearIconCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIconCache() {
        if (this.iconCache != null) {
            Map<String, Icon> map = this.iconCache;
            synchronized (map) {
                this.iconCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getIcon(String icon) {
        if (icon != null && icon.length() > 0) {
            Icon i;
            Map<String, Icon> map = this.iconCache;
            synchronized (map) {
                i = this.iconCache.get(icon);
            }
            if (i != null) {
                return i;
            }
            URL iconUrl = this.clazz.getResource(icon);
            if (iconUrl != null) {
                try {
                    i = new ImageIcon(iconUrl);
                    Map<String, Icon> map2 = this.iconCache;
                    synchronized (map2) {
                        this.iconCache.put(icon, i);
                    }
                    return i;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    @Override
    public String getKey(Component c, String suffix) {
        String name = c.getName();
        if (name == null) {
            return null;
        }
        return name + suffix;
    }
}

