/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.swing.ContainerRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class JComponentRefresher
extends ContainerRefresher {
    private static final Logger logger = Logger.getLogger(JComponentRefresher.class.getName());
    public static final String SUFFIX_TIP = ".tip";
    public static final String SUFFIX_BORDER_TITLE = ".border.title";

    public JComponentRefresher(SwingLocalizer localizer) {
        super(localizer);
    }

    @Override
    public boolean refresh(Object o) {
        boolean result = false;
        JComponent c = (JComponent)o;
        result |= this.refreshToolTipText(c);
        result |= this.refreshBorderTitle(c);
        return result |= super.refresh(o);
    }

    public boolean refreshToolTipText(JComponent c) {
        String key = this.localizer.getKey(c, SUFFIX_TIP);
        if (this.localizer.containsKey(key)) {
            String tip = this.localizer.getString(key);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("refreshToolTipText: " + key + " = " + tip);
            }
            if (tip != null) {
                if (tip.length() < 1) {
                    tip = null;
                }
                c.setToolTipText(tip);
                return true;
            }
        }
        return false;
    }

    public boolean refreshBorderTitle(JComponent c) {
        Border b = c.getBorder();
        if (b != null && b instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)b;
            String key = this.localizer.getKey(c, SUFFIX_BORDER_TITLE);
            if (this.localizer.containsKey(key)) {
                String title = this.localizer.getString(key);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("refreshBorderTitle: " + key + " = " + title);
                }
                if (title != null) {
                    tb.setTitle(title);
                    return true;
                }
            }
        }
        return false;
    }
}

