/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.swing.JComponentRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;

public class JTabbedPaneRefresher
extends JComponentRefresher {
    private static final Logger logger = Logger.getLogger(JTabbedPaneRefresher.class.getName());
    public static final String SUFFIX_TAB_TITLE = ".tab.title";
    public static final String SUFFIX_TAB_TIP = ".tab.tip";
    public static final String SUFFIX_TAB_ICON = ".tab.icon";

    public JTabbedPaneRefresher(SwingLocalizer localizer) {
        super(localizer);
    }

    @Override
    public boolean refresh(Object o) {
        boolean result = false;
        JTabbedPane tp = (JTabbedPane)o;
        result |= this.refreshTabs(tp);
        return result |= super.refresh(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshTabs(JTabbedPane c) {
        boolean result = false;
        Object object = c.getTreeLock();
        synchronized (object) {
            int n = c.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component t = c.getComponentAt(i);
                if (t == null) continue;
                String key = this.localizer.getKey(t, SUFFIX_TAB_TITLE);
                if (this.localizer.containsKey(key)) {
                    String title = this.localizer.getString(key);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("refreshTabTitle: " + key + " = " + title);
                    }
                    if (title != null) {
                        c.setTitleAt(i, title);
                        result = true;
                    }
                }
                if (this.localizer.containsKey(key = this.localizer.getKey(t, SUFFIX_TAB_TIP))) {
                    String tip = this.localizer.getString(key);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("refreshTabTip: " + key + " = " + tip);
                    }
                    if (tip != null) {
                        c.setToolTipTextAt(i, tip);
                        result = true;
                    }
                }
                if (!this.localizer.containsKey(key = this.localizer.getKey(t, SUFFIX_TAB_ICON))) continue;
                String icon = this.localizer.getString(key);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("refreshTabIcon: " + key + " = " + icon);
                }
                if (icon == null) continue;
                c.setIconAt(i, this.localizer.getIcon(icon));
                result = true;
            }
        }
        return result;
    }
}

