/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.swing.JComponentRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JViewport;

public class JViewportRefresher
extends JComponentRefresher {
    private static final Logger logger = Logger.getLogger(JViewportRefresher.class.getName());

    public JViewportRefresher(SwingLocalizer localizer) {
        super(localizer);
    }

    @Override
    public boolean refresh(Object o) {
        boolean result = super.refresh(o);
        JViewport vp = (JViewport)o;
        Component v = vp.getView();
        if (v != null) {
            try {
                if (JViewportRefresher.isLocalizable(v)) {
                    result |= this.localizer.refresh(v);
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return result;
    }
}

