/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.swing.ComponentRefresher;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Label;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LabelRefresher
extends ComponentRefresher {
    private static final Logger logger = Logger.getLogger(LabelRefresher.class.getName());
    public static final String SUFFIX_TEXT = ".text";

    public LabelRefresher(SwingLocalizer localizer) {
        super(localizer);
    }

    @Override
    public boolean refresh(Object o) {
        boolean result = false;
        Label l = (Label)o;
        result |= this.refreshLabelText(l);
        return result |= super.refresh(o);
    }

    public boolean refreshLabelText(Label c) {
        String key = this.localizer.getKey(c, SUFFIX_TEXT);
        if (this.localizer.containsKey(key)) {
            String text = this.localizer.getString(key);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("refreshLabelText: " + key + " = " + text);
            }
            if (text != null) {
                c.setText(text);
                return true;
            }
        }
        return false;
    }
}

