/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.LocalizerUtil;
import com.spacekiller.util.localizer.swing.LocaleListCellRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;

public class LocaleChooserComboBox
extends JComboBox {
    private static final long serialVersionUID = 5230950127677221891L;
    private List<Locale> locales;

    public LocaleChooserComboBox() {
        this.setEditable(false);
        this.setRenderer(LocaleListCellRenderer.SHARED_INSTANCE);
    }

    public List<Locale> getLocales() {
        return Collections.unmodifiableList(this.locales);
    }

    public void setLocales(List<Locale> locales) {
        this.locales = new ArrayList<Locale>(locales);
        this.refresh();
    }

    public void setAvailableLocales(Class clazz) throws IOException {
        this.setAvailableLocales(clazz, clazz.getName());
    }

    public void setAvailableLocales(Class clazz, String baseName) throws IOException {
        LocalizerUtil util = LocalizerUtil.getInstance();
        List locales = util.enumerateAvailableLocales(clazz, baseName);
        this.setLocales(locales);
    }

    public void refresh() {
        Locale locale = (Locale)this.getSelectedItem();
        int index = -1;
        this.removeAllItems();
        List<Locale> locales = this.locales;
        if (locales != null) {
            for (Locale item : locales) {
                if (item == locale) {
                    index = this.getItemCount();
                }
                this.addItem(item);
            }
        }
        this.setSelectedIndex(index);
    }
}

