/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import java.awt.Component;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class LocaleListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1324773939726031156L;
    public static final LocaleListCellRenderer SHARED_INSTANCE = new LocaleListCellRenderer();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null && value instanceof Locale) {
            Locale locale = (Locale)value;
            String text = this.getLocaleText(locale);
            String tip = this.getLocaleTooltipText(locale);
            Icon icon = this.getLocaleIcon(locale);
            if (text == null) {
                text = locale.toString();
            }
            this.setText(text);
            this.setToolTipText(tip);
            this.setIcon(icon);
        }
        return comp;
    }

    protected String getLocaleText(Locale locale) {
        String text = locale.getDisplayName(locale);
        if (text == null || text.length() < 1) {
            text = "<default>";
        }
        return text;
    }

    protected String getLocaleTooltipText(Locale locale) {
        return locale.toString();
    }

    protected Icon getLocaleIcon(Locale locale) {
        return null;
    }
}

