/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.localizer.swing;

import com.spacekiller.util.localizer.Localizable;
import com.spacekiller.util.localizer.swing.ContainerHandler;
import com.spacekiller.util.localizer.swing.SwingLocalizer;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class LocalizablePanel
extends JPanel
implements Localizable {
    private static final long serialVersionUID = 1395093383842597532L;
    private ContainerHandler containerHandler = new ContainerHandler(this);
    private SwingLocalizer localizer;
    private Map<Class, Boolean> localizableClassMap;
    private Map<Object, Boolean> localizableObjectMap;

    public LocalizablePanel() {
    }

    public LocalizablePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public LocalizablePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public LocalizablePanel(LayoutManager layout) {
        super(layout);
    }

    public synchronized SwingLocalizer getLocalizer() {
        return this.localizer;
    }

    public synchronized void setLocalizer(SwingLocalizer localizer) {
        if (this.localizer == localizer) {
            return;
        }
        this.localizer = localizer;
        this.containerHandler.setLocalizer(localizer);
        if (localizer != null) {
            ResourceBundle bundle = localizer.getBundle();
            Locale locale = bundle == null ? null : bundle.getLocale();
            this.setLocale(locale);
            localizer.refresh(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalizable(Object o) {
        Map<Object, Boolean> objectMap;
        Boolean value;
        if (o == null) {
            return false;
        }
        boolean result = true;
        Map<Class, Boolean> classMap = this.localizableClassMap;
        if (classMap != null) {
            for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                value = classMap.get(clazz);
                if (value == null) continue;
                result = value;
                break;
            }
        }
        if ((objectMap = this.localizableObjectMap) != null) {
            if (o instanceof Component) {
                Component comp;
                Object object = comp.getTreeLock();
                synchronized (object) {
                    for (comp = (Component)o; comp != null; comp = comp.getParent()) {
                        Boolean value2 = objectMap.get(comp);
                        if (value2 == null) continue;
                        result = value2;
                        break;
                    }
                }
            } else {
                value = objectMap.get(o);
                if (value != null) {
                    result = value;
                }
            }
        }
        return result;
    }

    protected Map<Class, Boolean> getLocalizableClassMap() {
        return this.localizableClassMap;
    }

    protected void setLocalizableClassMap(Map<Class, Boolean> localizableClassMap) {
        this.localizableClassMap = localizableClassMap;
    }

    protected Map<Object, Boolean> getLocalizableObjectMap() {
        return this.localizableObjectMap;
    }

    protected void setLocalizableObjectMap(Map<Object, Boolean> localizableObjectMap) {
        this.localizableObjectMap = localizableObjectMap;
    }
}

