/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public abstract class AbstractCellEditor
extends AbstractCellRenderer {
    private static final long serialVersionUID = -8446036157730629223L;
    private EventListenerList listenerList = new EventListenerList();
    private int clickCountToStart = 2;
    private ChangeEvent changeEvent;
    private static final Logger logger = Logger.getLogger(AbstractCellEditor.class.getName());

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    public void cancelCellEditing() {
        logger.fine("" + this.getClass().getName() + ".cancelCellEditing");
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof CellEditorListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i]).editingCanceled(this.changeEvent);
        }
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof CellEditorListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i]).editingStopped(this.changeEvent);
        }
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    public void setClickCountToStart(int newClickCountToStart) {
        this.clickCountToStart = newClickCountToStart;
    }

    public boolean stopCellEditing() {
        logger.fine("" + this + ".stopCellEditing");
        this.fireEditingStopped();
        return true;
    }
}

