/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import javax.swing.JPanel;

public class BackgroundPanel
extends JPanel {
    private static final long serialVersionUID = 2277461924006861134L;
    private boolean customBackgroundEnabled = true;
    private Paint backgroundPaint = Color.white;
    private Image backgroundImage = null;

    public BackgroundPanel() {
        this.initBackgroundPanel();
    }

    protected void initBackgroundPanel() {
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.customBackgroundEnabled) {
            super.paintComponent(g);
        } else {
            this.paintCustomBackground(g);
        }
    }

    public boolean isCustomBackgroundEnabled() {
        return this.customBackgroundEnabled;
    }

    public void setCustomBackgroundEnabled(boolean customBackgroundEnabled) {
        this.customBackgroundEnabled = customBackgroundEnabled;
    }

    protected void paintCustomBackground(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundImage != null) {
            Image img = this.backgroundImage;
            int sx1 = 0;
            int sy1 = 0;
            int sx2 = img.getWidth(null);
            int sy2 = img.getHeight(null);
            int dx1 = 0;
            int dy1 = 0;
            int dx2 = width;
            int dy2 = height;
            g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.backgroundPaint);
            g.fillRect(0, 0, width, height);
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
    }
}

