/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.Fadeable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class FadeUtil {
    private FadeUtil() {
    }

    public static Color getFadeColor(Color col, float alpha) {
        if (alpha == 1.0f) {
            return col;
        }
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        int a = (int)((float)col.getAlpha() * alpha);
        return new Color(r, g, b, a);
    }

    public static void fadeIn(Fadeable fadeable, int steps, int ms) {
        FadeUtil.fade(fadeable, 1.0f, steps, ms, false);
    }

    public static void fadeOut(Fadeable fadeable, int steps, int ms) {
        FadeUtil.fade(fadeable, 0.0f, steps, ms, false);
    }

    public static void fadeOutAndRemove(Fadeable fadeable, int steps, int ms) {
        FadeUtil.fade(fadeable, 0.0f, steps, ms, true);
    }

    public static void fade(Fadeable fadeable, float alpha, int steps, int ms, boolean remove) {
        int delay = ms;
        float startAlpha = fadeable.getAlpha();
        float endAlpha = alpha;
        Fader fader = new Fader(fadeable, startAlpha, endAlpha, steps, remove);
        Timer timer = new Timer(delay, fader);
        fader.timer = timer;
        timer.setRepeats(true);
        timer.start();
    }

    protected static class Fader
    implements ActionListener {
        private Fadeable fadeable;
        private int steps;
        private boolean remove;
        private float alpha;
        private float delta;
        private int step;
        private Timer timer;

        public Fader(Fadeable fadeable, float startAlpha, float endAlpha, int steps, boolean remove) {
            this.fadeable = fadeable;
            this.steps = steps;
            this.remove = remove;
            this.alpha = startAlpha;
            this.delta = (endAlpha - startAlpha) / (float)steps;
            this.step = 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.alpha += this.delta;
            this.fadeable.setAlpha(this.alpha);
            this.fadeable.repaint();
            ++this.step;
            if (this.step >= this.steps) {
                Component comp;
                Container parent;
                if (this.remove && this.fadeable instanceof Component && (parent = (comp = (Component)((Object)this.fadeable)).getParent()) != null) {
                    parent.remove(comp);
                    parent.repaint();
                }
                if (this.timer != null) {
                    this.timer.stop();
                    this.timer = null;
                }
            }
        }
    }
}

