/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.DocumentAdapter;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class FileField
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = 1153434775654695077L;
    private String path;
    private int fileSelectionMode = 0;
    private JTextField jTextFieldPath = null;
    private JButton jButtonBrowse = null;
    private transient ItemListener itemListeners;
    private static final Logger logger = Logger.getLogger(FileField.class.getName());

    public FileField() {
        this.initialize();
        this.initFileField();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.insets = new Insets(0, 1, 0, 0);
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(299, 45));
        this.add((Component)this.getJTextFieldPath(), gridBagConstraints);
        this.add((Component)this.getJButtonBrowse(), gridBagConstraints1);
    }

    private JTextField getJTextFieldPath() {
        if (this.jTextFieldPath == null) {
            this.jTextFieldPath = new JTextField();
            this.jTextFieldPath.setOpaque(false);
        }
        return this.jTextFieldPath;
    }

    private JButton getJButtonBrowse() {
        if (this.jButtonBrowse == null) {
            this.jButtonBrowse = new JButton();
            this.jButtonBrowse.setToolTipText("Browse..");
            this.jButtonBrowse.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonBrowse.setMinimumSize(new Dimension(23, 23));
            this.jButtonBrowse.setMaximumSize(new Dimension(23, 23));
            this.jButtonBrowse.setPreferredSize(new Dimension(23, 23));
            this.jButtonBrowse.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/browse_file.gif")));
            this.jButtonBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileField.this.actionBrowse();
                }
            });
        }
        return this.jButtonBrowse;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getJTextFieldPath().setEnabled(enabled);
        this.getJButtonBrowse().setEnabled(enabled);
    }

    public File getFile() {
        return this.path == null || this.path.length() < 1 ? null : new File(this.path);
    }

    public void setFile(File file) {
        this.setPath(file == null ? null : file.getPath());
    }

    protected void refresh() {
        String path = this.getPath();
        if (path == null) {
            path = "";
        }
        if (!path.equals(this.getJTextFieldPath().getText())) {
            this.getJTextFieldPath().setText(path);
        }
    }

    public String getPath() {
        return this.path;
    }

    public synchronized void setPath(String path) {
        this.path = path;
        this.refresh();
        File file = this.getFile();
        ItemEvent ev = new ItemEvent(this, 701, file, 1);
        this.fireItemStateChanged(ev);
    }

    protected void actionBrowse() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogType(0);
        File dir = null;
        if (this.path != null && this.path.length() > 0 && (f = new File(this.path)).exists()) {
            if (f.isFile()) {
                f = f.getParentFile();
            }
            if (f != null) {
                dir = f;
            }
        }
        chooser.setCurrentDirectory(dir);
        chooser.setFileSelectionMode(this.fileSelectionMode);
        chooser.showDialog(this, "Select");
        File sel = chooser.getSelectedFile();
        if (sel != null) {
            this.getJTextFieldPath().setText(sel.getPath());
        }
    }

    protected void initFileField() {
        this.getJTextFieldPath().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void handle(DocumentEvent e) {
                FileField.this.setPath(FileField.this.getJTextFieldPath().getText());
            }
        });
        DropTarget target = new DropTarget(this.getJTextFieldPath(), new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    File f;
                    dtde.acceptDrop(0x40000000);
                    Transferable trans = dtde.getTransferable();
                    List list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                    if (list != null && !list.isEmpty() && (f = (File)list.get(0)) != null) {
                        FileField.this.getJTextFieldPath().setText(f.getPath());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        });
        this.getJTextFieldPath().setDropTarget(target);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        if (this.itemListeners == null) {
            return;
        }
        this.itemListeners.itemStateChanged(e);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners((EventListener)this.itemListeners, ItemListener.class);
    }

    @Override
    public Object[] getSelectedObjects() {
        File file = this.getFile();
        if (file == null) {
            return new Object[0];
        }
        return new Object[]{file};
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }
}

