/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class GraphicsDevicePropertyEditor
extends JPanel
implements PropertyEditor,
ItemSelectable {
    private static final long serialVersionUID = 8916849644998793522L;
    private GraphicsDevice displayDevice;
    private boolean refreshing = false;
    private EventListenerList itemListeners = new EventListenerList();
    private JComboBox comboBoxDevice;

    public GraphicsDevicePropertyEditor() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.comboBoxDevice = new JComboBox();
        this.comboBoxDevice.setOpaque(false);
        this.comboBoxDevice.setToolTipText("Display device");
        this.comboBoxDevice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!GraphicsDevicePropertyEditor.this.refreshing) {
                    GraphicsDevicePropertyEditor.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxDevice = new GridBagConstraints();
        gbc_comboBoxDevice.weightx = 1.0;
        gbc_comboBoxDevice.fill = 2;
        gbc_comboBoxDevice.gridx = 0;
        gbc_comboBoxDevice.gridy = 0;
        this.add((Component)this.comboBoxDevice, gbc_comboBoxDevice);
        this.refresh();
    }

    public GraphicsDevice getDisplayDevice() {
        return this.displayDevice;
    }

    public void setDisplayDevice(GraphicsDevice displayDevice) {
        this.displayDevice = displayDevice;
        this.refresh();
    }

    protected void fireItemEvent(ItemEvent e) {
        Object[] l = this.itemListeners.getListenerList();
        for (int c = 0; c < l.length; c += 2) {
            ((ItemListener)l[c + 1]).itemStateChanged(e);
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListeners.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(ItemListener.class, l);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        if (this.displayDevice == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.displayDevice;
        }
        return objectArray;
    }

    @Override
    public void setValue(Object value) {
        this.setDisplayDevice((GraphicsDevice)value);
    }

    @Override
    public Object getValue() {
        return this.getDisplayDevice();
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return GraphicsDevicePropertyEditor.formatDisplayDevice(this.getDisplayDevice());
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(GraphicsDevicePropertyEditor.parseDisplayDevice(text));
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    protected JComboBox getComboBoxDevice() {
        return this.comboBoxDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            GraphicsDevice dev = this.getDisplayDevice();
            this.getComboBoxDevice().removeAllItems();
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] arr = env == null ? null : env.getScreenDevices();
            int sel = -1;
            if (arr != null) {
                for (int i = 0; i < arr.length; ++i) {
                    GraphicsDevice d = arr[i];
                    if (d == dev) {
                        sel = this.getComboBoxDevice().getItemCount();
                    }
                    this.getComboBoxDevice().addItem(d);
                }
            }
            this.getComboBoxDevice().setSelectedIndex(sel);
        }
        finally {
            this.refreshing = false;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.getComboBoxDevice().setEnabled(enabled);
    }

    protected void apply() {
        GraphicsDevice dev = null;
        Object item = this.getComboBoxDevice().getSelectedItem();
        if (item != null && item instanceof GraphicsDevice) {
            dev = (GraphicsDevice)item;
        }
        this.setValue(dev);
        this.fireItemEvent(new ItemEvent(this, 701, dev, 1));
    }

    public static String formatDisplayDevice(GraphicsDevice dev) {
        String id;
        String string = id = dev == null ? null : dev.getIDstring();
        if (id == null) {
            id = "";
        }
        return id;
    }

    public static GraphicsDevice parseDisplayDevice(String text) {
        if (text != null && text.length() > 0) {
            GraphicsDevice[] arr;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = arr = env == null ? null : env.getScreenDevices();
            if (arr != null) {
                for (GraphicsDevice dev : arr) {
                    if (!text.equals(dev.getIDstring())) continue;
                    return dev;
                }
            }
        }
        return null;
    }
}

