/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Vector;

public class GridBagResizeSupport
implements MouseListener,
MouseMotionListener {
    private Container container;
    private Point startPoint;
    private int gridx = -1;
    private int gridy = -1;
    private int relativePosition = 0;
    private int spacing = 4;
    private int dividerSize = 4;

    public GridBagResizeSupport(Container container) {
        this.setContainer(container);
    }

    protected void adjustGridHeight(int gridy, int pady) {
        Iterator i = this.getGridYComponents(gridy);
        while (i.hasNext()) {
            Component comp = (Component)i.next();
            GridBagConstraints gbc = this.getGridBagConstraints(comp);
            if (gbc == null) continue;
            gbc.ipady += pady;
            this.getGridBagLayout().setConstraints(comp, gbc);
        }
    }

    protected void adjustGridWidth(int gridx, int padx) {
        Iterator i = this.getGridXComponents(gridx);
        while (i.hasNext()) {
            Component comp = (Component)i.next();
            GridBagConstraints gbc = this.getGridBagConstraints(comp);
            if (gbc == null) continue;
            gbc.ipadx += padx;
            this.getGridBagLayout().setConstraints(comp, gbc);
        }
    }

    protected boolean containsGrid(Component comp, int gridx, int gridy) {
        GridBagConstraints gbc = this.getGridBagConstraints(comp);
        return gbc == null ? false : this.containsGrid(gbc, gridx, gridy);
    }

    protected boolean containsGrid(GridBagConstraints gbc, int gridx, int gridy) {
        return this.containsGridX(gbc, gridx) && this.containsGridY(gbc, gridy);
    }

    protected boolean containsGridX(GridBagConstraints gbc, int gridx) {
        return gbc.gridx <= gridx && gbc.gridx + gbc.gridwidth > gridx;
    }

    protected boolean containsGridY(GridBagConstraints gbc, int gridy) {
        return gbc.gridy <= gridy && gbc.gridy + gbc.gridheight > gridy;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    protected GridBagConstraints getGridBagConstraints(Component comp) {
        GridBagLayout layout = this.getGridBagLayout();
        return layout == null ? null : layout.getConstraints(comp);
    }

    protected GridBagLayout getGridBagLayout() {
        LayoutManager layout = this.getContainer().getLayout();
        if (layout != null && layout instanceof GridBagLayout) {
            return (GridBagLayout)layout;
        }
        return null;
    }

    protected Iterator getGridXComponents(int gridx) {
        Component[] comps = this.getContainer().getComponents();
        Vector<Component> v = new Vector<Component>();
        for (int c = 0; c < comps.length; ++c) {
            GridBagConstraints gbc = this.getGridBagConstraints(comps[c]);
            if (gbc == null || !this.containsGridX(gbc, gridx)) continue;
            v.add(comps[c]);
        }
        return v.iterator();
    }

    protected int getGridXSplitIndex(int x, int[] widths) {
        int count = widths.length;
        int i = 0;
        int space = this.getSpacing();
        for (int c = 0; c < count; ++c) {
            if (x >= (i += widths[c]) + space) continue;
            if (x > i - space) {
                return c;
            }
            return -1;
        }
        return -1;
    }

    protected Iterator getGridYComponents(int gridy) {
        Component[] comps = this.getContainer().getComponents();
        Vector<Component> v = new Vector<Component>();
        for (int c = 0; c < comps.length; ++c) {
            GridBagConstraints gbc = this.getGridBagConstraints(comps[c]);
            if (gbc == null || !this.containsGridY(gbc, gridy)) continue;
            v.add(comps[c]);
        }
        return v.iterator();
    }

    protected int getGridYSplitIndex(int y, int[] heights) {
        int count = heights.length;
        int i = 0;
        int space = this.getSpacing();
        for (int c = 0; c < count; ++c) {
            if (y >= (i += heights[c]) + space) continue;
            if (y > i - space) {
                return c;
            }
            return -1;
        }
        return -1;
    }

    public int getSpacing() {
        return this.spacing;
    }

    protected boolean isComponent(int x, int y) {
        Component comp = this.getContainer().getComponentAt(x, y);
        return comp != null && comp != this.getContainer();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (this.gridx < 0 && this.gridy < 0) {
            return;
        }
        int[][] dims = this.getGridBagLayout().getLayoutDimensions();
        int[] widths = dims[0];
        int[] heights = dims[1];
        if (this.gridx >= 0) {
            int relativeX = e.getX() - this.startPoint.x;
            this.paintVerticalDivider(this.gridx, widths, this.relativePosition);
            this.relativePosition = relativeX;
            this.paintVerticalDivider(this.gridx, widths, this.relativePosition);
        } else if (this.gridy >= 0) {
            int relativeY = e.getY() - this.startPoint.y;
            this.paintHorizontalDivider(this.gridy, heights, this.relativePosition);
            this.relativePosition = relativeY;
            this.paintHorizontalDivider(this.gridy, heights, this.relativePosition);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.container.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        Container cont = this.getContainer();
        if (cont == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        Cursor cursor = Cursor.getDefaultCursor();
        if (!this.isComponent(x, y)) {
            int[][] dims = this.getGridBagLayout().getLayoutDimensions();
            int[] widths = dims[0];
            int[] heights = dims[1];
            int splitX = this.getGridXSplitIndex(x, widths);
            int splitY = this.getGridYSplitIndex(y, heights);
            if (splitX >= 0 || splitY >= 0) {
                cursor = splitX >= 0 ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(8);
            }
        }
        this.container.setCursor(cursor);
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        int y;
        this.startPoint = null;
        int x = e.getX();
        if (!this.isComponent(x, y = e.getY())) {
            int[][] dims = this.getGridBagLayout().getLayoutDimensions();
            int[] widths = dims[0];
            int[] heights = dims[1];
            int splitX = this.getGridXSplitIndex(x, widths);
            int splitY = this.getGridYSplitIndex(y, heights);
            if (splitX >= 0 || splitY >= 0) {
                if (splitX >= 0) {
                    splitY = 0;
                    this.startPoint = new Point(x, y);
                    this.gridx = splitX;
                    this.gridy = -1;
                    this.relativePosition = 0;
                    this.paintVerticalDivider(splitX, widths, this.relativePosition);
                } else if (splitY >= 0) {
                    this.startPoint = new Point(x, y);
                    this.gridx = -1;
                    this.gridy = splitY;
                    this.relativePosition = 0;
                    this.paintHorizontalDivider(splitY, heights, this.relativePosition);
                }
            }
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        boolean adjust;
        if (this.gridx < 0 && this.gridy < 0) {
            return;
        }
        int[][] dims = this.getGridBagLayout().getLayoutDimensions();
        int[] widths = dims[0];
        boolean bl = adjust = !e.isPopupTrigger();
        if (this.gridx >= 0) {
            this.paintVerticalDivider(this.gridx, widths, this.relativePosition);
        }
        if (adjust) {
            if (this.gridx >= 0) {
                this.adjustGridWidth(this.gridx, this.relativePosition);
                this.adjustGridWidth(this.gridx + 1, -this.relativePosition);
            } else if (this.gridy >= 0) {
                this.adjustGridHeight(this.gridy, this.relativePosition);
                this.adjustGridHeight(this.gridy + 1, -this.relativePosition);
            }
            this.getContainer().validate();
            this.getContainer().doLayout();
            this.getContainer().repaint();
        }
        this.gridx = -1;
        this.gridy = -1;
    }

    protected void paintDivider(int x, int y, int w, int h) {
        Graphics g = this.getContainer().getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        g.fillRect(x, y, w, h);
        g.setPaintMode();
        g.dispose();
    }

    protected void paintHorizontalDivider(int gridy, int[] heights, int relativeY) {
        int y = 0;
        int count = Math.min(heights.length, gridy + 1);
        for (int c = 0; c < count; ++c) {
            y += heights[c];
        }
        int divSize = this.getDividerSize();
        this.paintDivider(0, y + relativeY - divSize / 2, this.getContainer().getWidth(), divSize);
    }

    protected void paintVerticalDivider(int gridx, int[] widths, int relativeX) {
        int x = 0;
        int count = Math.min(widths.length, gridx + 1);
        for (int c = 0; c < count; ++c) {
            x += widths[c];
        }
        int divSize = this.getDividerSize();
        this.paintDivider(x + relativeX - divSize / 2, 0, divSize, this.getContainer().getHeight());
    }

    public synchronized void setContainer(Container newContainer) {
        if (this.container != null) {
            this.container.removeMouseListener(this);
            this.container.removeMouseMotionListener(this);
        }
        this.container = newContainer;
        if (newContainer != null) {
            newContainer.addMouseListener(this);
            newContainer.addMouseMotionListener(this);
        }
    }

    public synchronized void setDividerSize(int newDividerSize) {
        this.dividerSize = newDividerSize;
    }

    public synchronized void setSpacing(int newSpacing) {
        this.spacing = newSpacing;
    }
}

