/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.LookAndFeelType;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelManager {
    private static LookAndFeelManager instance = null;
    private Vector components = new Vector();
    private Vector types = new Vector();

    public void addLookAndFeelType(LookAndFeelType type) {
        if (type != null && !this.types.contains(type)) {
            this.types.add(type);
        }
    }

    public static LookAndFeelManager getInstance() {
        if (instance == null) {
            instance = new LookAndFeelManager();
        }
        return instance;
    }

    void initMultiLookAndFeel() {
    }

    public LookAndFeelType[] getLookAndFeelTypes() {
        LookAndFeelType[] rc = new LookAndFeelType[this.types.size()];
        rc = this.types.toArray(rc);
        return rc;
    }

    protected void refreshComponents() {
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Component c;
            WeakReference ref = (WeakReference)i.next();
            if (ref != null && (c = (Component)ref.get()) != null) {
                this.refreshComponentsRecursive(c);
                continue;
            }
            i.remove();
        }
    }

    protected void refreshComponentsRecursive(Component comp) {
        if (comp != null) {
            SwingUtilities.updateComponentTreeUI(comp);
        }
    }

    public void registerComponent(Component c) {
        if (c == null) {
            return;
        }
        WeakReference<Component> ref = new WeakReference<Component>(c);
        if (!this.components.contains(ref)) {
            this.components.add(ref);
        }
    }

    public void removeLookAndFeelType(LookAndFeelType type) {
        this.types.remove(type);
    }

    public synchronized void setLookAndFeel(LookAndFeel laf) throws Exception {
        if (laf == null) {
            return;
        }
        UIManager.setLookAndFeel(laf);
        this.refreshComponents();
    }

    public void unregisterComponent(Component c) {
        if (c == null) {
            return;
        }
        this.components.remove(new WeakReference<Component>(c));
    }
}

