/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.Data;
import com.spacekiller.util.swing.PopupWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Point;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuListener;

public class PopupManager {
    private static final Logger logger = Logger.getLogger(PopupManager.class.getName());
    private static PopupManager sharedInstance;

    protected PopupManager() {
    }

    public static PopupManager getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new PopupManager();
        }
        return sharedInstance;
    }

    public void showPopup(Component owner, Component contents, int x, int y) {
        this.showPopup(owner, contents, x, y, null);
    }

    public void showPopup(Component owner, Component contents, int x, int y, PopupMenuListener listener) {
        this.showPopupWindow(owner, contents, x, y, listener);
    }

    boolean showPopupJ14(Component owner, Component contents, int x, int y) {
        try {
            Class<?> popupClass = Class.forName("javax.swing.Popup");
            Class<?> popupFactoryClass = Class.forName("javax.swing.PopupFactory");
            Method getSharedInstanceMethod = popupFactoryClass.getMethod("getSharedInstance", new Class[0]);
            Object factory = getSharedInstanceMethod.invoke(null, new Object[0]);
            Method getPopupMethod = popupFactoryClass.getMethod("getPopup", Component.class, Component.class, Integer.TYPE, Integer.TYPE);
            Object popup = getPopupMethod.invoke(factory, owner, contents, Data.toInteger((int)x), Data.toInteger((int)y));
            Method showMethod = popupClass.getMethod("show", new Class[0]);
            showMethod.invoke(popup, new Object[0]);
            logger.fine("Popup Java 1.4 => " + popup);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected void showPopupWindow(Component owner, Component contents, int x, int y, PopupMenuListener listener) {
        PopupWindow popupWindow = new PopupWindow(owner);
        Container container = null;
        if (contents instanceof Container) {
            container = (Container)contents;
        }
        if (container == null) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setLayout(new GridLayout(1, 1));
            panel.add(contents);
            container = panel;
        }
        if (listener != null) {
            logger.fine("PENDING.. install Dummy-PopupMenuListener: " + listener);
        }
        popupWindow.setContentPane(container);
        popupWindow.pack();
        Point point = this.translateToScreen(owner, x, y);
        popupWindow.setLocation(point.x, point.y);
        popupWindow.showPopup();
    }

    protected Point translateToScreen(Component component, int x, int y) {
        while (component != null) {
            x += component.getX();
            y += component.getY();
            component = component.getParent();
        }
        return new Point(x, y);
    }
}

