/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PopupWindow
extends JWindow {
    private static final long serialVersionUID = 5972353236739288554L;
    private static final Logger logger = Logger.getLogger(PopupWindow.class.getName());
    private PopupChangeListener popupChangeListener = new PopupChangeListener();
    private OwnerWindowListener ownerWindowListener = new OwnerWindowListener();
    private Timer looser;

    public PopupWindow() {
        this.initPopupWindow();
    }

    public PopupWindow(Component invoker) {
        this(PopupWindow.getFrame(invoker));
    }

    public PopupWindow(Frame invoker) {
        super(invoker);
        this.initPopupWindow();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    protected static Frame getFrame(Component comp) {
        while (comp != null) {
            if (comp instanceof Frame) {
                return (Frame)comp;
            }
            comp = comp.getParent();
        }
        return null;
    }

    protected void handleLostTimerEvent() {
        if (this.getFocusOwner() == null) {
            this.dispose();
        }
    }

    public void hidePopup() {
        MenuSelectionManager.defaultManager().removeChangeListener(this.popupChangeListener);
        this.getOwner().removeComponentListener(this.ownerWindowListener);
        super.setVisible(false);
    }

    protected void initPopupWindow() {
        this.looser = new Timer(2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PopupWindow.this.handleLostTimerEvent();
            }
        });
        this.looser.setRepeats(false);
        this.getOwner().addComponentListener(this.ownerWindowListener);
        this.enableEvents(77L);
        this.enableInputMethods(false);
    }

    protected boolean isSubPopupMenu(MenuElement menuElement) {
        JPopupMenu popupMenu;
        Component invoker;
        Component comp;
        if (menuElement != null && (comp = menuElement.getComponent()) != null && comp instanceof JPopupMenu && (invoker = (popupMenu = (JPopupMenu)comp).getInvoker()) != null) {
            return this.isAncestorOf(invoker);
        }
        return false;
    }

    protected void popupFocusGained(FocusEvent ev) {
        logger.info("popupFocusGained: " + ev);
    }

    protected void popupFocusLost(FocusEvent ev) {
        logger.info("popupFocusLost: " + ev);
        if (this.getFocusOwner() == null && !this.looser.isRunning()) {
            this.looser.start();
        }
    }

    protected void popupMenuSelectionStateChanged(ChangeEvent ev) {
        logger.info("popupMenuSelectionStateChanged: " + ev);
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] popupPath = msm.getSelectedPath();
        if (popupPath != null && popupPath.length > 0 && !this.isSubPopupMenu(popupPath[0])) {
            this.dispose();
        }
    }

    public void showPopup() {
        logger.info("showPopup: " + this);
        MenuSelectionManager.defaultManager().addChangeListener(this.popupChangeListener);
        super.setVisible(true);
        this.requestFocus();
    }

    public class OwnerWindowListener
    implements ComponentListener {
        @Override
        public void componentResized(ComponentEvent e) {
            PopupWindow.this.dispose();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            PopupWindow.this.dispose();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            PopupWindow.this.dispose();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    protected class PopupFocusHandler
    implements FocusListener,
    ContainerListener {
        protected PopupFocusHandler() {
            this.installComponent(PopupWindow.this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            PopupWindow.this.popupFocusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            PopupWindow.this.popupFocusLost(e);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component comp = e.getChild();
            if (comp != null) {
                this.installComponent(comp);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component comp = e.getChild();
            if (comp != null) {
                this.uninstallComponent(comp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void installComponent(Component comp) {
            comp.addFocusListener(this);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                Object object = cont.getTreeLock();
                synchronized (object) {
                    cont.addContainerListener(this);
                    int count = cont.getComponentCount();
                    for (int c = 0; c < count; ++c) {
                        this.installComponent(cont.getComponent(c));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void uninstallComponent(Component comp) {
            comp.removeFocusListener(this);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                Object object = cont.getTreeLock();
                synchronized (object) {
                    cont.removeContainerListener(this);
                    int count = cont.getComponentCount();
                    for (int c = 0; c < count; ++c) {
                        this.uninstallComponent(cont.getComponent(c));
                    }
                }
            }
        }

        protected void finalize() throws Throwable {
            this.uninstallComponent(PopupWindow.this);
        }
    }

    protected class PopupChangeListener
    implements ChangeListener {
        protected PopupChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PopupWindow.this.popupMenuSelectionStateChanged(e);
        }
    }
}

