/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.swing.AnimatedComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SimpleWebBrowser
extends JPanel {
    private static final long serialVersionUID = -4374478999988740393L;
    private JEditorPane ivjJEditorPane1 = null;
    private JPanel ivjJPanel1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JTextField ivjJTextFieldURL = null;
    private AnimatedComponent ivjAnimatedComponent1 = null;
    private JButton ivjJButtonBack = null;
    private JButton ivjJButtonForward = null;
    private JButton ivjJButton = null;
    private JButton ivjJButton1 = null;
    private String fieldUrl = new String();
    private RuntimeContext fieldRuntimeContext = null;
    private Vector history = new Vector();
    private int historyIndex = -1;
    private boolean ignoreHistory = false;
    private static final Logger logger = Logger.getLogger(SimpleWebBrowser.class.getName());

    public SimpleWebBrowser() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void action_Back() {
        try {
            this.ignoreHistory = true;
            if (this.historyIndex > 0) {
                --this.historyIndex;
                this.setURL("" + this.history.elementAt(this.historyIndex));
            }
        }
        finally {
            this.ignoreHistory = false;
        }
    }

    private void action_Browse() {
        this.setURL(this.getJTextFieldURL().getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void action_Forward() {
        try {
            this.ignoreHistory = true;
            if (this.historyIndex < this.history.size() - 1) {
                ++this.historyIndex;
                this.setURL("" + this.history.elementAt(this.historyIndex));
            }
        }
        finally {
            this.ignoreHistory = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void action_Reload() {
        try {
            this.ignoreHistory = true;
            this.defaultBrowser_Url(this.getUrl());
        }
        finally {
            this.ignoreHistory = false;
        }
    }

    private void action_Stop() {
    }

    protected void checkEnable() {
        this.getJButtonBack().setEnabled(this.history.size() > 0 && this.historyIndex > 0);
        this.getJButtonForward().setEnabled(this.history.size() > 0 && this.historyIndex < this.history.size() - 1);
    }

    private void connEtoC1() {
        try {
            this.defaultBrowser_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.action_Browse();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.action_Back();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.action_Forward();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.action_Reload();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.action_Stop();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(PropertyChangeEvent arg1) {
        try {
            this.defaultBrowser_Url(String.valueOf(this.getUrl()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void defaultBrowser_Initialize() {
        this.getJEditorPane1().setEditable(false);
        this.getJEditorPane1().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent ev) {
                SimpleWebBrowser.this.handleHyperlinkUpdate(ev);
            }
        });
    }

    private void defaultBrowser_Url(String arg1) {
        String s1 = this.getJTextFieldURL().getText();
        String s2 = arg1;
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if (!s1.equals(s2)) {
            this.getJTextFieldURL().setText(s2);
            if (!this.ignoreHistory) {
                ++this.historyIndex;
                while (this.history.size() > this.historyIndex) {
                    this.history.removeElementAt(this.historyIndex);
                }
                this.history.addElement(s2);
            }
        }
        this.checkEnable();
        final String urlStr = arg1;
        new Thread(new Runnable(){

            @Override
            public void run() {
                logger.fine("Loading: " + urlStr);
                try {
                    SimpleWebBrowser.this.getJEditorPane1().setPage(urlStr);
                    logger.fine("Complete: " + urlStr);
                }
                catch (Exception e) {
                    logger.fine("Error loading: " + urlStr);
                    SimpleWebBrowser.this.handleException(e);
                }
            }
        }).start();
    }

    private AnimatedComponent getAnimatedComponent1() {
        if (this.ivjAnimatedComponent1 == null) {
            try {
                this.ivjAnimatedComponent1 = new AnimatedComponent();
                this.ivjAnimatedComponent1.setName("AnimatedComponent1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAnimatedComponent1;
    }

    private JButton getJButton() {
        if (this.ivjJButton == null) {
            try {
                this.ivjJButton = new JButton();
                this.ivjJButton.setName("JButton");
                this.ivjJButton.setToolTipText("Reload");
                this.ivjJButton.setOpaque(false);
                this.ivjJButton.setText("");
                this.ivjJButton.setMaximumSize(new Dimension(25, 25));
                this.ivjJButton.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/nav_refresh.gif")));
                this.ivjJButton.setPreferredSize(new Dimension(25, 25));
                this.ivjJButton.setMargin(new Insets(2, 2, 2, 2));
                this.ivjJButton.setMinimumSize(new Dimension(25, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton;
    }

    private JButton getJButton1() {
        if (this.ivjJButton1 == null) {
            try {
                this.ivjJButton1 = new JButton();
                this.ivjJButton1.setName("JButton1");
                this.ivjJButton1.setToolTipText("Forward");
                this.ivjJButton1.setOpaque(false);
                this.ivjJButton1.setText("");
                this.ivjJButton1.setMaximumSize(new Dimension(25, 25));
                this.ivjJButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/nav_stop.gif")));
                this.ivjJButton1.setPreferredSize(new Dimension(25, 25));
                this.ivjJButton1.setMargin(new Insets(2, 2, 2, 2));
                this.ivjJButton1.setMinimumSize(new Dimension(25, 25));
                this.ivjJButton1.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton1;
    }

    private JButton getJButtonBack() {
        if (this.ivjJButtonBack == null) {
            try {
                this.ivjJButtonBack = new JButton();
                this.ivjJButtonBack.setName("JButtonBack");
                this.ivjJButtonBack.setToolTipText("Back");
                this.ivjJButtonBack.setOpaque(false);
                this.ivjJButtonBack.setText("");
                this.ivjJButtonBack.setMaximumSize(new Dimension(25, 25));
                this.ivjJButtonBack.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/bkward_nav.gif")));
                this.ivjJButtonBack.setPreferredSize(new Dimension(25, 25));
                this.ivjJButtonBack.setMargin(new Insets(2, 2, 2, 2));
                this.ivjJButtonBack.setMinimumSize(new Dimension(25, 25));
                this.ivjJButtonBack.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButtonBack;
    }

    private JButton getJButtonForward() {
        if (this.ivjJButtonForward == null) {
            try {
                this.ivjJButtonForward = new JButton();
                this.ivjJButtonForward.setName("JButtonForward");
                this.ivjJButtonForward.setToolTipText("Forward");
                this.ivjJButtonForward.setOpaque(false);
                this.ivjJButtonForward.setText("");
                this.ivjJButtonForward.setMaximumSize(new Dimension(25, 25));
                this.ivjJButtonForward.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/forward_nav.gif")));
                this.ivjJButtonForward.setPreferredSize(new Dimension(25, 25));
                this.ivjJButtonForward.setMargin(new Insets(2, 2, 2, 2));
                this.ivjJButtonForward.setMinimumSize(new Dimension(25, 25));
                this.ivjJButtonForward.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButtonForward;
    }

    private JEditorPane getJEditorPane1() {
        if (this.ivjJEditorPane1 == null) {
            try {
                this.ivjJEditorPane1 = new JEditorPane();
                this.ivjJEditorPane1.setName("JEditorPane1");
                this.ivjJEditorPane1.setOpaque(false);
                this.ivjJEditorPane1.setBounds(0, 0, 6, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJEditorPane1;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setOpaque(false);
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJTextFieldURL = new GridBagConstraints();
                constraintsJTextFieldURL.gridx = 4;
                constraintsJTextFieldURL.gridy = 0;
                constraintsJTextFieldURL.fill = 1;
                constraintsJTextFieldURL.weightx = 1.0;
                constraintsJTextFieldURL.insets = new Insets(4, 4, 4, 0);
                this.getJPanel1().add((Component)this.getJTextFieldURL(), constraintsJTextFieldURL);
                GridBagConstraints constraintsAnimatedComponent1 = new GridBagConstraints();
                constraintsAnimatedComponent1.gridx = 5;
                constraintsAnimatedComponent1.gridy = 0;
                constraintsAnimatedComponent1.fill = 1;
                constraintsAnimatedComponent1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getAnimatedComponent1(), constraintsAnimatedComponent1);
                GridBagConstraints constraintsJButtonBack = new GridBagConstraints();
                constraintsJButtonBack.gridx = 0;
                constraintsJButtonBack.gridy = 0;
                constraintsJButtonBack.fill = 1;
                constraintsJButtonBack.insets = new Insets(4, 4, 4, 0);
                this.getJPanel1().add((Component)this.getJButtonBack(), constraintsJButtonBack);
                GridBagConstraints constraintsJButtonForward = new GridBagConstraints();
                constraintsJButtonForward.gridx = 1;
                constraintsJButtonForward.gridy = 0;
                constraintsJButtonForward.fill = 1;
                constraintsJButtonForward.insets = new Insets(4, 4, 4, 0);
                this.getJPanel1().add((Component)this.getJButtonForward(), constraintsJButtonForward);
                GridBagConstraints constraintsJButton = new GridBagConstraints();
                constraintsJButton.gridx = 2;
                constraintsJButton.gridy = 0;
                constraintsJButton.fill = 1;
                constraintsJButton.insets = new Insets(4, 4, 4, 0);
                this.getJPanel1().add((Component)this.getJButton(), constraintsJButton);
                GridBagConstraints constraintsJButton1 = new GridBagConstraints();
                constraintsJButton1.gridx = 3;
                constraintsJButton1.gridy = 0;
                constraintsJButton1.fill = 1;
                constraintsJButton1.insets = new Insets(4, 4, 4, 0);
                this.getJPanel1().add((Component)this.getJButton1(), constraintsJButton1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getJEditorPane1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JTextField getJTextFieldURL() {
        if (this.ivjJTextFieldURL == null) {
            try {
                this.ivjJTextFieldURL = new JTextField();
                this.ivjJTextFieldURL.setName("JTextFieldURL");
                this.ivjJTextFieldURL.setOpaque(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldURL;
    }

    public RuntimeContext getRuntimeContext() {
        return this.fieldRuntimeContext;
    }

    public String getUrl() {
        return this.fieldUrl;
    }

    public String getURL() {
        return this.getUrl();
    }

    private void handleException(Throwable exception) {
        logger.log(Level.WARNING, exception.getMessage(), exception);
    }

    private void initConnections() throws Exception {
        this.getJTextFieldURL().addActionListener(this.ivjEventHandler);
        this.getJButtonBack().addActionListener(this.ivjEventHandler);
        this.getJButtonForward().addActionListener(this.ivjEventHandler);
        this.getJButton().addActionListener(this.ivjEventHandler);
        this.getJButton1().addActionListener(this.ivjEventHandler);
        this.addPropertyChangeListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("DefaultBrowser");
            this.setLayout(new GridBagLayout());
            this.setSize(475, 340);
            GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
            constraintsJPanel1.gridx = 0;
            constraintsJPanel1.gridy = 0;
            constraintsJPanel1.fill = 1;
            constraintsJPanel1.weightx = 1.0;
            this.add((Component)this.getJPanel1(), constraintsJPanel1);
            GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
            constraintsJScrollPane1.gridx = 0;
            constraintsJScrollPane1.gridy = 1;
            constraintsJScrollPane1.fill = 1;
            constraintsJScrollPane1.weightx = 1.0;
            constraintsJScrollPane1.weighty = 1.0;
            this.add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
            this.initConnections();
            this.connEtoC1();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            SimpleWebBrowser aSimpleWebBrowser = new SimpleWebBrowser();
            frame.setContentPane(aSimpleWebBrowser);
            frame.setSize(aSimpleWebBrowser.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.fieldRuntimeContext = runtimeContext;
    }

    public void setUrl(String url) {
        String oldValue = this.fieldUrl;
        this.fieldUrl = url;
        this.firePropertyChange("url", oldValue, url);
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    protected void handleHyperlinkUpdate(HyperlinkEvent ev) {
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String path = ev.getDescription();
            if (path == null) {
                return;
            }
            String url = this.buildURL(path);
            if (url != null) {
                url = this.getCanonicalURL(url);
            }
            this.setUrl(url);
        }
    }

    protected String buildURL(String path) {
        int x;
        if (path == null) {
            return null;
        }
        if (path.indexOf(58) >= 0) {
            return path;
        }
        String s = this.fieldUrl;
        if (s != null && (x = s.indexOf(63)) >= 0) {
            s = s.substring(0, x);
        }
        if (path.startsWith("?") || path.startsWith("#")) {
            s = s != null ? s + path : path;
            return s;
        }
        if (path.startsWith("/")) {
            if (s != null) {
                if ((s = this.getRootURL(s)).endsWith("/")) {
                    s = s.substring(0, s.length() - 1);
                }
                s = s + path;
            } else {
                s = path;
            }
            return s;
        }
        s = s != null ? (s.endsWith("/") ? s + path : ((x = s.lastIndexOf(47)) >= 0 ? s.substring(0, x + 1) + path : path)) : path;
        return s;
    }

    protected String getRootURL(String url) {
        int y = url.indexOf("://");
        if (y < 0) {
            return url;
        }
        int z = url.indexOf(47, y + 3);
        if (z < 0) {
            return url;
        }
        return url.substring(0, z);
    }

    protected String getCanonicalURL(String url) {
        int from = 0;
        int len = url.length();
        int x = url.indexOf("/../", from);
        if (x < 0) {
            return url;
        }
        LinkedList<String> list = new LinkedList<String>();
        while (from < len) {
            x = url.indexOf(47, from);
            if (x < 0) {
                list.add(url.substring(from));
                break;
            }
            String s = url.substring(from, x + 1);
            if (s.equals("../")) {
                if (!list.isEmpty()) {
                    list.removeLast();
                }
            } else {
                list.add(s);
            }
            from = x + 1;
        }
        StringBuffer sbuf = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            sbuf.append((String)i.next());
        }
        return sbuf.toString();
    }

    class IvjEventHandler
    implements ActionListener,
    PropertyChangeListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SimpleWebBrowser.this.getJTextFieldURL()) {
                SimpleWebBrowser.this.connEtoC2(e);
            }
            if (e.getSource() == SimpleWebBrowser.this.getJButtonBack()) {
                SimpleWebBrowser.this.connEtoC3(e);
            }
            if (e.getSource() == SimpleWebBrowser.this.getJButtonForward()) {
                SimpleWebBrowser.this.connEtoC4(e);
            }
            if (e.getSource() == SimpleWebBrowser.this.getJButton()) {
                SimpleWebBrowser.this.connEtoC5(e);
            }
            if (e.getSource() == SimpleWebBrowser.this.getJButton1()) {
                SimpleWebBrowser.this.connEtoC6(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == SimpleWebBrowser.this && evt.getPropertyName().equals("url")) {
                SimpleWebBrowser.this.connEtoC7(evt);
            }
        }
    }
}

