/*
 * Decompiled with CFR 0.152.
 */
import com.spacekiller.plaf.bene.BeneLookAndFeel;
import com.spacekiller.plaf.bene.TextureArea;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class Blaf {
    public static final String PROPERTY_BLAF_TEXTURE = "blaf.texture";
    public static final String DEFAULT_TEXTURE = "/com/spacekiller/plaf/bene/icons/blaf_texture.jpg";

    public static void main(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        String mainClassName = null;
        if (args.length < 1) {
            Blaf.help();
            throw new RuntimeException("Invalid arguments specified.");
        }
        mainClassName = args[0];
        String[] mainArgs = new String[args.length - 1];
        for (int i = 0; i < mainArgs.length; ++i) {
            mainArgs[i] = args[1 + i];
        }
        try {
            File f;
            Class<?> mainClass = Class.forName(mainClassName);
            Method mainMeth = mainClass.getMethod("main", String[].class);
            if (!Modifier.isStatic(mainMeth.getModifiers())) {
                throw new Exception("Invalid main method: " + mainMeth);
            }
            URL textureURL = null;
            String prop = System.getProperty(PROPERTY_BLAF_TEXTURE);
            if (prop != null && (f = new File(prop)).exists() && f.isFile()) {
                textureURL = f.toURL();
            }
            if (textureURL == null) {
                textureURL = Blaf.class.getResource(DEFAULT_TEXTURE);
            }
            Blaf.initBeneLookAndFeel(textureURL);
            mainMeth.invoke(null, new Object[]{mainArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("" + e);
        }
    }

    public static BufferedImage createBufferedImage(Image img) {
        BufferedImage rc = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        rc.getGraphics().drawImage(img, 0, 0, null);
        return rc;
    }

    public static void initBeneLookAndFeel(URL textureURL) throws Exception {
        Paint texture = new Color(10, 30, 50);
        Image img = new ImageIcon(textureURL).getImage();
        Rectangle anchor = new Rectangle(img.getWidth(null), img.getHeight(null));
        BufferedImage bufferedImage = Blaf.createBufferedImage(img);
        texture = new TexturePaint(bufferedImage, anchor);
        TextureArea beneArea = new TextureArea(texture);
        BeneLookAndFeel blaf = new BeneLookAndFeel(beneArea);
        System.out.println("LookAndFeel: " + blaf);
        UIManager.setLookAndFeel(blaf);
    }

    public static void help() {
        System.out.println("Syntax: java Blaf [main-class] {arguments}");
        System.out.println();
    }
}

