/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import com.spacekiller.plaf.bene.BeneArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;

public class BeneIcons {
    private BeneIcons() {
    }

    public static class BeneRadioButtonIcon
    implements Icon {
        private int width = 14;
        private int height = 14;
        private Icon selectedIcon;
        private Color outlineColor;
        private Color centerColor;
        private Color pressedColor;
        private Color light1;
        private Color light2;
        private Color dark1;
        private Color dark2;

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            boolean selected = model.isSelected();
            boolean pressed = model.isPressed();
            if (pressed) {
                g.setColor(this.pressedColor);
                g.fillArc(x, y, 13, 13, 0, 360);
            } else {
                g.setColor(this.light1);
                g.drawArc(x + 1, y + 1, 11, 11, 45, 180);
                g.setColor(this.dark1);
                g.drawArc(x + 1, y + 1, 11, 11, 235, 180);
                g.setColor(this.light2);
                g.drawArc(x + 2, y + 2, 9, 9, 45, 180);
                g.setColor(this.dark2);
                g.drawArc(x + 2, y + 2, 9, 9, 235, 180);
                g.setColor(this.centerColor);
                g.fillArc(x + 2, y + 2, 9, 9, 0, 360);
            }
            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.6f));
            g.drawArc(x, y, 13, 13, 0, 360);
            if (selected && this.selectedIcon != null) {
                this.selectedIcon.paintIcon(c, g, x + 1, y + 1);
            }
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public Icon getSelectedIcon() {
            return this.selectedIcon;
        }

        public void setSelectedIcon(Icon selectedIcon) {
            this.selectedIcon = selectedIcon;
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineColor(Color outlineColor) {
            this.outlineColor = outlineColor;
        }

        public Color getDark1() {
            return this.dark1;
        }

        public void setDark1(Color dark1) {
            this.dark1 = dark1;
        }

        public Color getDark2() {
            return this.dark2;
        }

        public void setDark2(Color dark2) {
            this.dark2 = dark2;
        }

        public Color getLight1() {
            return this.light1;
        }

        public void setLight1(Color light1) {
            this.light1 = light1;
        }

        public Color getLight2() {
            return this.light2;
        }

        public void setLight2(Color light2) {
            this.light2 = light2;
        }

        public Color getCenterColor() {
            return this.centerColor;
        }

        public void setCenterColor(Color centerColor) {
            this.centerColor = centerColor;
        }

        public Color getPressedColor() {
            return this.pressedColor;
        }

        public void setPressedColor(Color pressedColor) {
            this.pressedColor = pressedColor;
        }
    }

    public static class BeneCheckBoxIcon
    implements Icon {
        private int width = 14;
        private int height = 14;
        private BeneArea beneArea;
        private BeneArea beneAreaPressed;
        private Icon selectedIcon;
        private Color outlineColor;

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            BeneArea area;
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            boolean selected = model.isSelected();
            boolean pressed = model.isPressed();
            BeneArea beneArea = area = pressed ? this.beneAreaPressed : this.beneArea;
            if (area != null) {
                area.paintArea(c, g, x, y, this.width, this.height);
            }
            if (this.outlineColor != null) {
                g.setColor(this.outlineColor);
                g.drawRect(x, y, this.width, this.height);
            }
            if (selected && this.selectedIcon != null) {
                this.selectedIcon.paintIcon(c, g, x, y);
            }
        }

        public BeneArea getBeneArea() {
            return this.beneArea;
        }

        public void setBeneArea(BeneArea beneArea) {
            this.beneArea = beneArea;
        }

        public BeneArea getBeneAreaPressed() {
            return this.beneAreaPressed;
        }

        public void setBeneAreaPressed(BeneArea beneAreaPressed) {
            this.beneAreaPressed = beneAreaPressed;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public Icon getSelectedIcon() {
            return this.selectedIcon;
        }

        public void setSelectedIcon(Icon selectedIcon) {
            this.selectedIcon = selectedIcon;
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineColor(Color outlineColor) {
            this.outlineColor = outlineColor;
        }
    }
}

