/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import com.spacekiller.plaf.bene.BeneArea;
import com.spacekiller.plaf.bene.BeneBumps;
import com.spacekiller.plaf.bene.BeneScrollButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class BeneScrollBarUI
extends MetalScrollBarUI {
    private BeneArea beneArea = (BeneArea)UIManager.get("ScrollBarUI.beneArea");
    private BeneArea beneAreaOpaque = (BeneArea)UIManager.get("ScrollBarUI.beneAreaOpaque");
    private BeneArea beneAreaThumb = (BeneArea)UIManager.get("ScrollBarUI.beneAreaThumb");
    private BeneArea beneAreaThumbOpaque = (BeneArea)UIManager.get("ScrollBarUI.beneAreaThumbOpaque");
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected BeneBumps bumps;

    public static ComponentUI createUI(JComponent c) {
        BeneScrollBarUI ui = new BeneScrollBarUI();
        return ui;
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            return;
        }
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        BeneArea area;
        BeneArea beneArea = area = c.isOpaque() ? this.beneAreaOpaque : this.beneArea;
        if (area != null) {
            area.paintArea(c, g, 0, 0, c.getWidth(), c.getHeight());
        }
        super.paint(g, c);
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        BeneArea area = c.isOpaque() ? this.beneAreaThumbOpaque : this.beneAreaThumb;
        boolean leftToRight = BeneScrollBarUI.isLeftToRight(c);
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                thumbBounds.width += 2;
                if (!leftToRight) {
                    g.translate(-1, 0);
                }
            }
            if (area != null) {
                area.paintArea(c, g, 0, 0, thumbBounds.width, thumbBounds.height);
            }
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            this.bumps.setBumpArea(thumbBounds.width - 6, thumbBounds.height - 7);
            this.bumps.paintIcon(c, g, 3, 4);
            if (!this.isFreeStanding) {
                thumbBounds.width -= 2;
                if (!leftToRight) {
                    g.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            if (area != null) {
                area.paintArea(c, g, 0, 0, thumbBounds.width, thumbBounds.height);
            }
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 3);
            this.bumps.setBumpArea(thumbBounds.width - 7, thumbBounds.height - 6);
            this.bumps.paintIcon(c, g, 4, 3);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.bumps = new BeneBumps(10, 10, thumbHighlightColor, thumbShadow, null);
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new BeneScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new BeneScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }
}

