/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import com.spacekiller.plaf.bene.BeneArea;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;

public class TextureArea
implements BeneArea {
    private Paint texture;
    private boolean fixed;
    private int test = 0;

    public TextureArea(Paint texture) {
        this.setTexture(texture);
    }

    public TextureArea(Paint texture, boolean fixed) {
        this(texture);
        this.setFixed(fixed);
    }

    protected void getRelativePosition(Component c, Point dst) {
        dst.x = 0;
        dst.y = 0;
        while (c != null && !(c instanceof JRootPane) && !(c instanceof Window)) {
            dst.x += c.getX();
            dst.y += c.getY();
            if (c instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)c;
                Point pos = pane.getViewport().getViewPosition();
                dst.x += pos.x;
                dst.y += pos.y;
            }
            c = c.getParent();
        }
    }

    protected Paint getTexture() {
        return this.texture;
    }

    @Override
    public void paintArea(Component comp, Graphics g, int x, int y, int w, int h) {
        Paint paint = this.getTexture();
        if (paint != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(paint);
            Rectangle clip = g2.getClipBounds();
            g2.clipRect(x, y, w, h);
            if (this.fixed) {
                g2.fillRect(x, y, w, h);
            } else {
                Point rel = new Point();
                this.getRelativePosition(comp, rel);
                g2.translate(-rel.x, -rel.y);
                g2.fillRect(x, y, w + rel.x, h + rel.y);
                g2.translate(rel.x, rel.y);
            }
            if (clip != null) {
                g2.setClip(clip.x, clip.y, clip.width, clip.height);
            }
        }
    }

    private void setTexture(Paint newTexture) {
        this.texture = newTexture;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    private void setFixed(boolean fixed) {
        this.fixed = fixed;
    }
}

