/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.Data;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanEditor;
import com.spacekiller.util.beans.FeatureEditor;
import com.spacekiller.util.beans.components.PaintablePropertyEditorDelegate;
import com.spacekiller.util.beans.components.PropertyEditorDelegate;
import com.spacekiller.util.swing.AbstractCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public abstract class AbstractPropertyEditorCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = 371250232938371416L;
    private GridBagConstraints gbcEditor;
    private PropertyEditorDelegate editorDelegate;
    private ComponentPropertyEditorDelegate componentPropertyEditorDelegate;
    private PaintablePropertyEditorDelegate propertyEditorDelegate;
    private TextFieldEditorDelegate textFieldDelegate;
    private JTextField textField;
    private CheckBoxEditorDelegate checkBoxDelegate;
    private JCheckBox checkBox;
    private PropertyEditorDelegate customEditorDelegate;
    private String nullString = "null";
    private Icon nullIcon = null;
    private boolean showCustomizerButton = true;
    private GridBagConstraints gbcCustomButton;
    private int row;
    private int column;
    private static final Logger logger = Logger.getLogger(AbstractPropertyEditorCellEditor.class.getName());

    public AbstractPropertyEditorCellEditor() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.propertyEditorDelegate = new PaintablePropertyEditorDelegate();
        this.componentPropertyEditorDelegate = new ComponentPropertyEditorDelegate();
        this.textField = this.createEditorTextField();
        this.textFieldDelegate = new TextFieldEditorDelegate(this.textField);
        this.checkBox = this.createEditorCheckBox();
        this.checkBoxDelegate = new CheckBoxEditorDelegate(this.checkBox);
        this.gbcEditor = new GridBagConstraints();
        this.gbcEditor.gridx = 0;
        this.gbcEditor.gridy = 0;
        this.gbcEditor.weightx = 1.0;
        this.gbcEditor.fill = 1;
        this.gbcCustomButton = new GridBagConstraints();
        this.gbcCustomButton.gridx = 1;
        this.gbcCustomButton.gridy = 0;
        this.gbcCustomButton.weightx = 0.0;
        this.gbcCustomButton.anchor = 13;
        this.gbcCustomButton.fill = 0;
        this.gbcCustomButton.insets = new Insets(0, 0, 0, 0);
    }

    protected JCheckBox createEditorCheckBox() {
        JCheckBox cb = new JCheckBox();
        cb.setOpaque(false);
        cb.setForeground(Color.black);
        cb.setHorizontalAlignment(0);
        cb.setMargin(new Insets(0, 0, 0, 0));
        return cb;
    }

    protected JTextField createEditorTextField() {
        JTextField l = new JTextField();
        l.setOpaque(false);
        l.setFont(Tools.getDefaultFont((int)0));
        l.setBorder(new CompoundBorder());
        return l;
    }

    protected abstract Object getBean(int var1, int var2);

    protected abstract BeanContext getBeanContextOfBean(int var1, int var2);

    protected Component getCellEditorComponent(Object value, boolean isSelected, boolean expanded, boolean leaf, int row, int column) {
        JButton button;
        PropertyEditor ped;
        this.setSelected(isSelected);
        this.setFocus(true);
        this.setRow(row);
        this.setColumn(column);
        this.setCustomEditorDelegate(null);
        this.editorDelegate = this.getPropertyEditorDelegate(value, isSelected, expanded, leaf, row, column);
        logger.fine("getCellEditorComponent: " + row + "," + column + " => " + value + "  delegate=" + this.editorDelegate);
        Component editorComp = this.editorDelegate == null ? null : this.editorDelegate.getComponent();
        this.removeAll();
        if (editorComp != null) {
            this.add(editorComp, this.gbcEditor);
        }
        if (this.isShowCustomizerButton() && (ped = this.getPropertyEditor(row, column)) != null && ped.supportsCustomEditor() && (button = this.getCustomizerButton()) != null) {
            this.add(button, this.gbcCustomButton);
        }
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        PropertyEditorDelegate delegate = this.getCustomEditorDelegate();
        if (delegate == null) {
            delegate = this.getEditorDelegate();
        }
        return delegate == null ? null : delegate.getCellEditorValue();
    }

    protected int getColumn() {
        return this.column;
    }

    protected PropertyEditorDelegate getCustomEditorDelegate() {
        return this.customEditorDelegate;
    }

    protected abstract JButton getCustomizerButton();

    protected PropertyEditorDelegate getEditorDelegate() {
        return this.editorDelegate;
    }

    protected PropertyEditorDelegate getNonPaintableBooleanDelegate(PropertyDescriptor property, PropertyEditor ped, Boolean value, boolean editable) {
        this.checkBoxDelegate.setPropertyEditor(ped);
        if (value == null) {
            this.checkBox.setEnabled(editable);
            this.checkBox.setSelected(false);
            this.checkBoxDelegate.setEditable(editable);
            return this.checkBoxDelegate;
        }
        this.checkBox.setEnabled(editable);
        this.checkBox.setSelected(value);
        this.checkBoxDelegate.setEditable(editable);
        return this.checkBoxDelegate;
    }

    protected PropertyEditorDelegate getNonPaintableDelegate(PropertyDescriptor property, PropertyEditor ped, Object value, int row, int column) {
        Class<?> propertyType;
        Class<?> clazz = propertyType = property == null ? null : property.getPropertyType();
        if (AbstractPropertyEditorCellEditor.isBooleanType(propertyType) && value instanceof Boolean) {
            return this.getNonPaintableBooleanDelegate(property, ped, (Boolean)value, true);
        }
        if (AbstractPropertyEditorCellEditor.isNumberType(propertyType) && value instanceof Number) {
            return this.getNonPaintableNumberDelegate(property, ped, (Number)value, row, column, true);
        }
        boolean editable = false;
        editable = ped == null ? propertyType == String.class || AbstractPropertyEditorCellEditor.isCharacterType(propertyType) : this.isPropertyEditorEditable(ped, value);
        return this.getNonPaintableTextDelegate(property, ped, value, row, column, editable);
    }

    protected PropertyEditorDelegate getNonPaintableNumberDelegate(PropertyDescriptor property, PropertyEditor ped, Number number, int row, int column, boolean editable) {
        this.textField.setEditable(editable);
        this.textField.setHorizontalAlignment(4);
        String text = null;
        text = ped == null ? (number == null ? "" : String.valueOf(number)) : ped.getAsText();
        this.textField.setText(String.valueOf(text));
        this.textFieldDelegate.setPropertyEditor(ped);
        this.textFieldDelegate.setEditable(editable);
        this.textFieldDelegate.setRow(row);
        this.textFieldDelegate.setColumn(column);
        return this.textFieldDelegate;
    }

    protected PropertyEditorDelegate getNonPaintableTextDelegate(PropertyDescriptor property, PropertyEditor ped, Object text, int row, int column, boolean editable) {
        if (ped != null) {
            text = ped.getAsText();
        }
        this.textField.setEditable(editable);
        this.textField.setHorizontalAlignment(2);
        this.textField.setText(String.valueOf(text));
        this.textFieldDelegate.setPropertyEditor(ped);
        this.textFieldDelegate.setEditable(editable);
        this.textFieldDelegate.setRow(row);
        this.textFieldDelegate.setColumn(column);
        return this.textFieldDelegate;
    }

    public Icon getNullIcon() {
        return this.nullIcon;
    }

    public String getNullString() {
        return this.nullString;
    }

    protected abstract PropertyDescriptor getPropertyDescriptor(int var1, int var2);

    protected abstract PropertyEditor getPropertyEditor(int var1, int var2);

    protected PropertyEditorDelegate getPropertyEditorDelegate(Object value, boolean isSelected, boolean expanded, boolean leaf, int row, int column) {
        PropertyEditor ped = this.getPropertyEditor(row, column);
        if (ped != null) {
            if (ped instanceof BeanEditor) {
                BeanEditor be = (BeanEditor)ped;
                be.setBeanContextOfBean(this.getBeanContextOfBean(row, column));
                be.setBean(this.getBean(row, column));
            }
            if (ped instanceof FeatureEditor) {
                FeatureEditor fed = (FeatureEditor)ped;
                fed.setFeatureDescriptor((FeatureDescriptor)this.getPropertyDescriptor(row, column));
            }
            ped.setValue(value);
            if (ped instanceof Component) {
                Component comp = (Component)((Object)ped);
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setOpaque(false);
                }
                this.componentPropertyEditorDelegate.setPropertyEditor(ped);
                this.componentPropertyEditorDelegate.setComponent(comp);
                return this.componentPropertyEditorDelegate;
            }
            if (ped.isPaintable()) {
                this.propertyEditorDelegate.setEditable(true);
                this.propertyEditorDelegate.setPropertyEditor(ped);
                return this.propertyEditorDelegate;
            }
        }
        PropertyDescriptor property = this.getPropertyDescriptor(row, column);
        return this.getNonPaintableDelegate(property, ped, value, row, column);
    }

    protected int getRow() {
        return this.row;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.getCellEditorComponent(value, isSelected, false, false, row, column);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        return this.getCellEditorComponent(value, isSelected, expanded, leaf, row, 0);
    }

    protected abstract void handleException(Throwable var1);

    public boolean isEditableDelegate() {
        if (this.editorDelegate != null) {
            return this.editorDelegate.isEditable();
        }
        return false;
    }

    protected boolean isPropertyEditorEditable(PropertyEditor ped, Object value) {
        if (ped == null) {
            return false;
        }
        try {
            ped.setValue(value);
            String textValue = ped.getAsText();
            ped.setAsText(textValue);
            ped.setValue(value);
            return true;
        }
        catch (Throwable e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Error while invoking PropertyEditor of type" + ped.getClass(), e);
            }
            return false;
        }
    }

    public boolean isShowCustomizerButton() {
        return this.showCustomizerButton;
    }

    private void setColumn(int newColumn) {
        this.column = newColumn;
    }

    protected void setCustomEditorDelegate(PropertyEditorDelegate newCustomEditorDelegate) {
        this.customEditorDelegate = newCustomEditorDelegate;
    }

    public void setNullIcon(Icon newNullIcon) {
        this.nullIcon = newNullIcon;
    }

    public void setNullString(String newNullString) {
        this.nullString = newNullString;
    }

    private void setRow(int newRow) {
        this.row = newRow;
    }

    public void setShowCustomizerButton(boolean newShowCustomizerButton) {
        this.showCustomizerButton = newShowCustomizerButton;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editorDelegate == null ? false : this.editorDelegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        try {
            if (!this.isEditableDelegate()) {
                logger.fine(" -> cancel (not editable): " + this);
                super.cancelCellEditing();
                return false;
            }
            logger.fine("stop cell-editing => " + this.getCellEditorValue());
            return super.stopCellEditing();
        }
        catch (Throwable e) {
            logger.fine("#0080 ==> something is wrong -> cancelling..");
            this.handleException(e);
            this.editorDelegate = null;
            super.cancelCellEditing();
            return false;
        }
    }

    public class ComponentPropertyEditorDelegate
    implements PropertyEditorDelegate {
        private PropertyEditor propertyEditor;
        private Component component;

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        public void setPropertyEditor(PropertyEditor ped) {
            this.propertyEditor = ped;
        }

        @Override
        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component comp) {
            this.component = comp;
        }

        @Override
        public boolean isEditable() {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            if (!this.isEditable()) {
                return null;
            }
            return this.propertyEditor.getValue();
        }
    }

    public class CheckBoxEditorDelegate
    implements PropertyEditorDelegate,
    ActionListener {
        private JCheckBox checkBox;
        private boolean editable = false;
        private PropertyEditor editor;

        public CheckBoxEditorDelegate(JCheckBox cb) {
            this.checkBox = cb;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            if (!this.isEditable()) {
                return null;
            }
            return this.checkBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Component getComponent() {
            return this.checkBox;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            AbstractPropertyEditorCellEditor.this.stopCellEditing();
        }

        public void setEditable(boolean b) {
            this.editable = b;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        public void setPropertyEditor(PropertyEditor ed) {
            this.editor = ed;
        }
    }

    public class TextFieldEditorDelegate
    implements PropertyEditorDelegate,
    ActionListener {
        private JTextField textField;
        private int row;
        private int col;
        private PropertyEditor editor;
        private boolean editable = false;

        public TextFieldEditorDelegate(JTextField tf) {
            this.textField = tf;
            this.textField.addActionListener(this);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.isEditable();
        }

        public void setRow(int i) {
            this.row = i;
        }

        public void setColumn(int i) {
            this.col = i;
        }

        @Override
        public Object getCellEditorValue() {
            if (!this.isEditable()) {
                return null;
            }
            Class<?> type = AbstractPropertyEditorCellEditor.this.getPropertyDescriptor(this.row, this.col).getPropertyType();
            String text = this.textField.getText();
            if (this.editor != null) {
                this.editor.setAsText(text);
                return this.editor.getValue();
            }
            if (type == String.class) {
                return text;
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return new Integer(text.trim());
            }
            if (type == Long.class || type == Long.TYPE) {
                return new Long(text.trim());
            }
            if (type == Short.class || type == Short.TYPE) {
                return new Short(text.trim());
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return new Byte(text.trim());
            }
            if (type == Double.class || type == Double.TYPE) {
                return new Double(text.trim());
            }
            if (type == Float.class || type == Float.TYPE) {
                return new Float(text.trim());
            }
            if (type == Character.class || type == Character.TYPE) {
                return text.length() < 1 ? Data.toCharacter((char)'\u0000') : Data.toCharacter((char)text.charAt(0));
            }
            throw new RuntimeException("Cannot handle property-type: " + type);
        }

        @Override
        public Component getComponent() {
            return this.textField;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            AbstractPropertyEditorCellEditor.this.stopCellEditing();
        }

        public void setEditable(boolean b) {
            this.editable = b;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        public void setPropertyEditor(PropertyEditor ed) {
            this.editor = ed;
        }
    }
}

