/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanEditor;
import com.spacekiller.util.beans.FeatureEditor;
import com.spacekiller.util.beans.components.PaintablePropertyEditorDelegate;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public abstract class AbstractPropertyEditorCellRenderer
extends AbstractCellRenderer
implements TableCellRenderer,
TreeCellRenderer {
    private static final long serialVersionUID = -3446014122388999198L;
    private PaintablePropertyEditorDelegate propertyEditorDelegate;
    private JLabel label;
    private JCheckBox checkBox;
    private String nullString = "null";
    private Icon nullIcon = null;
    private int row;
    private int column;
    private static final Logger logger = Logger.getLogger(AbstractPropertyEditorCellRenderer.class.getName());

    public AbstractPropertyEditorCellRenderer() {
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.propertyEditorDelegate = new PaintablePropertyEditorDelegate();
        this.label = this.createRendererLabel();
        this.checkBox = this.createRendererCheckBox();
    }

    protected JCheckBox createRendererCheckBox() {
        JCheckBox cb = new JCheckBox();
        cb.setOpaque(false);
        cb.setForeground(Color.black);
        cb.setHorizontalAlignment(0);
        cb.setMargin(new Insets(0, 0, 0, 0));
        return cb;
    }

    protected JLabel createRendererLabel() {
        JLabel l = new JLabel();
        l.setOpaque(false);
        l.setFont(Tools.getDefaultFont((int)0));
        return l;
    }

    protected abstract Object getBean(int var1, int var2);

    protected abstract BeanContext getBeanContextOfBean(int var1, int var2);

    protected Component getCellRendererComponent(Object value, boolean isSelected, boolean hasFocus, boolean expanded, boolean leaf, int row, int column) {
        this.setSelected(isSelected);
        this.setFocus(hasFocus);
        this.setColumn(column);
        this.setRow(row);
        Component comp = this.getPropertyRenderer(value, isSelected, hasFocus, expanded, leaf, row, column);
        this.removeAll();
        if (comp != null) {
            this.add(comp);
        }
        return this;
    }

    protected int getColumn() {
        return this.column;
    }

    protected Component getNonPaintableBooleanDelegate(PropertyDescriptor property, Boolean value) {
        if (value == null) {
            return this.getNonPaintableNullDelegate();
        }
        this.checkBox.setSelected(value);
        return this.checkBox;
    }

    protected Component getNonPaintableDelegate(PropertyDescriptor property, PropertyEditor ped, Object value, int row, int column) {
        Class<?> propertyType;
        Class<?> clazz = propertyType = property == null ? null : property.getPropertyType();
        if (AbstractPropertyEditorCellRenderer.isBooleanType(propertyType) && value instanceof Boolean) {
            return this.getNonPaintableBooleanDelegate(property, (Boolean)value);
        }
        if (AbstractPropertyEditorCellRenderer.isNumberType(propertyType) && value instanceof Number) {
            return this.getNonPaintableNumberDelegate(property, ped, (Number)value, row, column);
        }
        return this.getNonPaintableTextDelegate(property, ped, value, row, column);
    }

    protected Component getNonPaintableNullDelegate() {
        this.label.setHorizontalAlignment(2);
        this.label.setText(this.getNullString());
        this.label.setIcon(this.getNullIcon());
        return this.label;
    }

    protected Component getNonPaintableNumberDelegate(PropertyDescriptor property, PropertyEditor ped, Number number, int row, int column) {
        String text = null;
        text = ped == null ? String.valueOf(number) : ped.getAsText();
        if (number == null) {
            return this.getNonPaintableNullDelegate();
        }
        this.label.setHorizontalAlignment(4);
        this.label.setText(String.valueOf(text));
        this.label.setIcon(null);
        return this.label;
    }

    protected Component getNonPaintableTextDelegate(PropertyDescriptor property, PropertyEditor ped, Object text, int row, int column) {
        if (ped != null) {
            try {
                text = ped.getAsText();
            }
            catch (NullPointerException e) {
                logger.fine("Warning: " + e);
                text = null;
            }
        }
        this.label.setHorizontalAlignment(2);
        this.label.setText(String.valueOf(text));
        this.label.setIcon(null);
        return this.label;
    }

    public Icon getNullIcon() {
        return this.nullIcon;
    }

    public String getNullString() {
        return this.nullString;
    }

    protected abstract PropertyDescriptor getPropertyDescriptor(int var1, int var2);

    protected abstract PropertyEditor getPropertyEditor(int var1, int var2);

    protected Component getPropertyRenderer(Object value, boolean isSelected, boolean hasFocus, boolean expanded, boolean leaf, int row, int column) {
        PropertyEditor ped = this.getPropertyEditor(row, column);
        if (ped != null) {
            if (ped instanceof BeanEditor) {
                BeanEditor be = (BeanEditor)ped;
                be.setBeanContextOfBean(this.getBeanContextOfBean(row, column));
                be.setBean(this.getBean(row, column));
            }
            if (ped instanceof FeatureEditor) {
                FeatureEditor fed = (FeatureEditor)ped;
                fed.setFeatureDescriptor((FeatureDescriptor)this.getPropertyDescriptor(row, column));
            }
            ped.setValue(value);
            if (ped instanceof Component) {
                Component comp = (Component)((Object)ped);
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setOpaque(false);
                }
                return comp;
            }
            if (ped.isPaintable()) {
                this.propertyEditorDelegate.setPropertyEditor(ped);
                return this.propertyEditorDelegate;
            }
        }
        PropertyDescriptor property = this.getPropertyDescriptor(row, column);
        return this.getNonPaintableDelegate(property, ped, value, row, column);
    }

    protected int getRow() {
        return this.row;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getCellRendererComponent(value, isSelected, hasFocus, false, false, row, column);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.getCellRendererComponent(value, selected, hasFocus, expanded, leaf, row, 0);
    }

    protected void setColumn(int newColumn) {
        this.column = newColumn;
    }

    public void setNullIcon(Icon newNullIcon) {
        this.nullIcon = newNullIcon;
    }

    public void setNullString(String newNullString) {
        this.nullString = newNullString;
    }

    protected void setRow(int newRow) {
        this.row = newRow;
    }
}

