/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.DefaultFeatureHeaderRenderer;
import com.spacekiller.util.beans.model.BeanTableModel;
import com.spacekiller.util.swing.TableRowHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableModel;

public class BeanTable
extends JTable {
    private static final long serialVersionUID = -7347350462712685204L;
    private BeansToolkit beansToolkit;
    private BeanTableRowHeader tableRowHeader;
    private Component topLeftCorner;

    public BeanTable(BeansToolkit newBeansToolkit) {
        this.setBeansToolkit(newBeansToolkit);
        this.initBeanTable();
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            Component corner;
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setRowHeaderView((Component)((Object)this.getTableRowHeader()));
            JViewport rowHeaderViewport = scrollPane.getRowHeader();
            if (rowHeaderViewport != null) {
                rowHeaderViewport.setOpaque(false);
            }
            if ((corner = this.getTopLeftCorner()) != null) {
                scrollPane.setCorner("UPPER_LEFT_CORNER", corner);
            }
        }
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    protected Object getRowHeaderValue(int row) {
        Object rc = null;
        TableModel model = this.getModel();
        if (model instanceof BeanTableModel) {
            BeanTableModel beanModel = (BeanTableModel)model;
            rc = beanModel.getValueAt(row, -1);
        }
        return rc;
    }

    public BeanTableRowHeader getTableRowHeader() {
        return this.tableRowHeader;
    }

    public Component getTopLeftCorner() {
        return this.topLeftCorner;
    }

    protected void initBeanTable() {
        Color gridColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
        BeanTableRowHeader rowHeader = new BeanTableRowHeader();
        rowHeader.setTable(this);
        DefaultFeatureHeaderRenderer rowRenderer = new DefaultFeatureHeaderRenderer(this.getBeansToolkit());
        rowRenderer.setHeaderBorder(null);
        rowHeader.setRowHeaderCellRenderer(rowRenderer);
        rowHeader.setForeground(gridColor);
        this.setTableRowHeader(rowHeader);
        BeanTableTopLeftCorner topLeft = new BeanTableTopLeftCorner();
        topLeft.setForeground(gridColor);
        this.setTopLeftCorner(topLeft);
    }

    protected void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    protected void setTableRowHeader(BeanTableRowHeader newTableRowHeader) {
        this.tableRowHeader = newTableRowHeader;
    }

    protected void setTopLeftCorner(Component newTopLeftCorner) {
        this.topLeftCorner = newTopLeftCorner;
    }

    public class BeanTableTopLeftCorner
    extends JComponent {
        private static final long serialVersionUID = -7076993668434836842L;

        public BeanTableTopLeftCorner() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.getForeground());
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
        }
    }

    public class BeanTableRowHeader
    extends TableRowHeader {
        private static final long serialVersionUID = -866135472377868228L;

        protected Object getRowHeaderValue(int row) {
            return BeanTable.this.getRowHeaderValue(row);
        }
    }
}

