/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.BeanTree;
import com.spacekiller.util.beans.components.BeanTreeCellToolkit;
import com.spacekiller.util.beans.components.FeatureLabelToolkit;
import com.spacekiller.util.swing.AbstractCellEditor;
import java.awt.Component;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellEditor;

public class BeanTreeCellEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final long serialVersionUID = -2732630309168770199L;
    private BeanTreeCellToolkit cellToolkit;
    private boolean cancel = false;
    private static final Logger logger = Logger.getLogger(BeanTreeCellEditor.class.getName());

    protected BeanTreeCellEditor() {
        this.setOpaque(false);
    }

    public BeanTreeCellEditor(BeansToolkit btk, BeanTree beanTree) {
        this();
        this.setCellToolkit(this.createCellToolkit(btk, beanTree));
    }

    public BeanTreeCellEditor(BeanTreeCellToolkit tk) {
        this();
        this.setCellToolkit(tk);
    }

    protected BeanTreeCellToolkit createCellToolkit(BeansToolkit btk, BeanTree beanTree) {
        return new BeanTreeCellToolkit((JComponent)((Object)this), btk, 1, new FeatureLabelToolkit(), this, beanTree);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.cancel) {
            return null;
        }
        return this.getCellToolkit().getPropertyEditorCellEditor().getCellEditorValue();
    }

    public BeanTreeCellToolkit getCellToolkit() {
        return this.cellToolkit;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        this.cancel = false;
        this.setSelected(selected);
        this.setFocus(true);
        this.getCellToolkit().prepareTreeCellEditor(tree, value, selected, expanded, leaf, row);
        return this;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.WARNING, this.getClass().getName(), e);
    }

    private void setCellToolkit(BeanTreeCellToolkit newCellToolkit) {
        this.cellToolkit = newCellToolkit;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.getCellToolkit().getPropertyEditorCellEditor().shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        try {
            if (!this.getCellToolkit().getPropertyEditorCellEditor().isEditableDelegate()) {
                super.cancelCellEditing();
                return false;
            }
            return super.stopCellEditing();
        }
        catch (Throwable e) {
            logger.fine("#0060 ==> something is wrong -> cancelling..");
            this.handleException(e);
            this.cancel = true;
            super.cancelCellEditing();
            return false;
        }
    }
}

