/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.DefaultProperty;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.components.PropertyField;
import com.spacekiller.util.beans.components.PropertyPage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InvokeMethodPanel
extends JPanel {
    private static final long serialVersionUID = 3112181678127559848L;
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private Class type;
    private Object object;
    private Filter methodFilter;
    private ArrayList methods = new ArrayList();
    private Property[] paramProperties;
    private JLabel jLabel = null;
    private JComboBox jComboBoxMethod = null;
    private JButton jButtonInvoke = null;
    private JPanel jPanelParams = null;
    private PropertyField propertyFieldResult = null;
    private JLabel jLabel1 = null;
    private PropertyField propertyFieldObject = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private PropertyPage propertyPage = null;
    private static final Logger logger = Logger.getLogger(InvokeMethodPanel.class.getName());

    public InvokeMethodPanel() {
        this.initialize();
        this.initInvokeMethodPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 5;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.gridwidth = 2;
        gridBagConstraints9.insets = new Insets(4, 4, 4, 4);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints8.anchor = 16;
        gridBagConstraints8.gridy = 4;
        this.jLabel3 = new JLabel();
        this.jLabel3.setText("Result:");
        GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
        gridBagConstraints71.gridx = 0;
        gridBagConstraints71.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints71.gridwidth = 2;
        gridBagConstraints71.anchor = 17;
        gridBagConstraints71.gridy = 2;
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("Parameters:");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridy = 0;
        GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
        gridBagConstraints51.gridx = 0;
        gridBagConstraints51.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints51.anchor = 17;
        gridBagConstraints51.gridy = 0;
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Object:");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints4.gridy = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints2.gridy = 4;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        this.jLabel = new JLabel();
        this.jLabel.setText("Method:");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(372, 242));
        this.add((Component)this.jLabel, gridBagConstraints);
        this.add((Component)this.getJComboBoxMethod(), gridBagConstraints1);
        this.add((Component)this.getJButtonInvoke(), gridBagConstraints2);
        this.add((Component)this.getJPanelParams(), gridBagConstraints4);
        this.add((Component)this.jLabel1, gridBagConstraints51);
        this.add((Component)this.getPropertyFieldObject(), gridBagConstraints6);
        this.add((Component)this.jLabel2, gridBagConstraints71);
        this.add((Component)this.jLabel3, gridBagConstraints8);
        this.add((Component)this.getPropertyFieldResult(), gridBagConstraints9);
    }

    private JComboBox getJComboBoxMethod() {
        if (this.jComboBoxMethod == null) {
            this.jComboBoxMethod = new JComboBox();
            this.jComboBoxMethod.setOpaque(false);
            this.jComboBoxMethod.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InvokeMethodPanel.this.refreshParameters();
                    InvokeMethodPanel.this.checkEnable();
                }
            });
        }
        return this.jComboBoxMethod;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
        this.refresh();
    }

    public void setSelectedMethodName(String name) {
        int index = -1;
        int x = 0;
        for (Method m : this.methods) {
            if (name.equals(m.getName())) {
                index = x;
                break;
            }
            ++x;
        }
        if (index >= 0) {
            this.getJComboBoxMethod().setSelectedIndex(index);
        }
    }

    public void setSelectedMethod(Method meth) {
        int i = this.methods.indexOf(meth);
        if (i >= 0) {
            this.getJComboBoxMethod().setSelectedIndex(i);
        }
    }

    public Method getSelectedMethod() {
        int i = this.getJComboBoxMethod().getSelectedIndex();
        Method meth = null;
        if (i >= 0 && i < this.methods.size()) {
            meth = (Method)this.methods.get(i);
        }
        return meth;
    }

    public void refresh() {
        this.methods.clear();
        TreeMap<String, Method> map = new TreeMap<String, Method>();
        if (this.type != null) {
            Method[] meths = this.type.getMethods();
            for (int i = 0; i < meths.length; ++i) {
                Method meth = meths[i];
                if (this.methodFilter != null && !this.methodFilter.accept((Object)meth)) continue;
                String key = meth.getName() + "$" + i;
                map.put(key, meth);
            }
        }
        this.getJComboBoxMethod().removeAllItems();
        for (Method meth : map.values()) {
            String methTitle = meth.getName();
            this.getJComboBoxMethod().addItem(methTitle);
            this.methods.add(meth);
        }
    }

    public Filter getMethodFilter() {
        return this.methodFilter;
    }

    public void setMethodFilter(Filter methodFilter) {
        this.methodFilter = methodFilter;
        this.refresh();
    }

    private JButton getJButtonInvoke() {
        if (this.jButtonInvoke == null) {
            this.jButtonInvoke = new JButton();
            this.jButtonInvoke.setText("Invoke");
            this.jButtonInvoke.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonInvoke.setToolTipText("Invoke selected method...");
            this.jButtonInvoke.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/invoke_method.gif")));
            this.jButtonInvoke.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InvokeMethodPanel.this.actionInvoke();
                }
            });
        }
        return this.jButtonInvoke;
    }

    private JPanel getJPanelParams() {
        if (this.jPanelParams == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 0;
            this.jPanelParams = new JPanel();
            this.jPanelParams.setLayout(new GridBagLayout());
            this.jPanelParams.setOpaque(false);
            this.jPanelParams.add((Component)this.getPropertyPage(), gridBagConstraints3);
        }
        return this.jPanelParams;
    }

    private PropertyField getPropertyFieldResult() {
        if (this.propertyFieldResult == null) {
            this.propertyFieldResult = new PropertyField();
            this.propertyFieldResult.setEditable(false);
        }
        return this.propertyFieldResult;
    }

    protected void initInvokeMethodPanel() {
        this.checkEnable();
    }

    protected void checkEnable() {
        int x = this.getJComboBoxMethod().getSelectedIndex();
        this.getJButtonInvoke().setEnabled(x >= 0);
    }

    protected void actionInvoke() {
        try {
            Object obj = this.getObject();
            if (obj == null) {
                return;
            }
            Method meth = this.getSelectedMethod();
            if (meth == null) {
                return;
            }
            Object[] params = this.getParameterValues();
            Object result = meth.invoke(obj, params);
            String propName = "result";
            Class<Object> propType = Object.class;
            DefaultProperty prop = new DefaultProperty(propName, propType, result, true, false, true);
            this.getPropertyFieldResult().setProperty((Property)prop);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
        if (object != null) {
            this.setType(object.getClass());
        }
        try {
            String propName = "object";
            Class<Object> propType = Object.class;
            DefaultProperty prop = new DefaultProperty(propName, propType, object, true, false, true);
            this.getPropertyFieldObject().setProperty((Property)prop);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private PropertyField getPropertyFieldObject() {
        if (this.propertyFieldObject == null) {
            this.propertyFieldObject = new PropertyField();
            this.propertyFieldObject.setEditable(false);
        }
        return this.propertyFieldObject;
    }

    protected void refreshParameters() {
        Method method = this.getSelectedMethod();
        Class[] paramTypes = method == null ? new Class[]{} : method.getParameterTypes();
        String[] paramNames = null;
        if (method != null) {
            try {
                paramNames = Platform.getInstance().getClassRegistry().getParameterNames(method);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        Property[] paramProps = null;
        try {
            paramProps = new Property[paramTypes.length];
            for (int c = 0; c < paramTypes.length; ++c) {
                Class paramType = paramTypes[c];
                String paramName = null;
                if (paramNames != null && paramNames.length > c) {
                    paramName = String.valueOf(paramNames[c]);
                }
                if (paramName == null) {
                    paramName = "param" + c;
                }
                Object paramValue = null;
                boolean nullable = true;
                DefaultProperty prop = new DefaultProperty(paramName, paramType, paramValue, true, true, nullable);
                paramProps[c] = prop;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.paramProperties = paramProps;
        this.getPropertyPage().setProperties(paramProps);
    }

    private PropertyPage getPropertyPage() {
        if (this.propertyPage == null) {
            this.propertyPage = new PropertyPage();
            this.propertyPage.setOpaque(false);
        }
        return this.propertyPage;
    }

    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            this.setBeansToolkit(Platform.getInstance().getBeansToolkit());
        }
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        this.getPropertyPage().setBeansToolkit(beansToolkit);
    }

    public ClassRegistry getClassRegistry() {
        if (this.classRegistry == null) {
            this.setClassRegistry(Platform.getInstance().getClassRegistry());
        }
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    public Object[] getParameterValues() throws Exception {
        int num;
        Property[] props = this.paramProperties;
        int n = num = props == null ? 0 : props.length;
        if (num < 1) {
            return new Object[0];
        }
        Object[] values = new Object[num];
        for (int i = 0; i < num; ++i) {
            values[i] = props[i].getValue();
        }
        return values;
    }
}

