/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassDescriptor;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.DefaultProperty;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.components.ClassChooser;
import com.spacekiller.util.beans.components.PropertyPage;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.EventListener;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class NewObjectPanel
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = 7839308868171793688L;
    private ClassRegistry classRegistry;
    private BeansToolkit beansToolkit;
    private Filter classFilter;
    private int emptySearchAction;
    private transient ItemListener itemListeners;
    private boolean refreshing = false;
    private boolean refreshingParams = false;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JComboBox jComboBoxConstructor = null;
    private Property[] paramProperties;
    private ClassChooser classChooser = null;
    private JButton jButtonCreate = null;
    private JSplitPane jSplitPane = null;
    private transient ActionListener actionListeners;
    private PropertyPage propertyPageParams = null;
    private static final Logger logger = Logger.getLogger(NewObjectPanel.class.getName());

    public NewObjectPanel() {
        this.initialize();
        this.initPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.weightx = 1.0;
        this.setLayout(new GridBagLayout());
        this.setSize(510, 246);
        this.add((Component)this.getJSplitPane(), gridBagConstraints3);
    }

    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            this.setBeansToolkit(Platform.getInstance().getBeansToolkit());
        }
        return this.beansToolkit;
    }

    public Constructor getSelectedConstructor() {
        return (Constructor)this.getJComboBoxConstructor().getSelectedItem();
    }

    public void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
        this.getClassChooser().setBeansToolkit(this.beansToolkit);
        this.getPropertyPageParams().setBeansToolkit(this.beansToolkit);
        if (this.classRegistry == null && this.beansToolkit != null) {
            this.setClassRegistry(this.beansToolkit.getClassRegistry());
        }
    }

    protected void initPanel() {
        ClassChooser.DefaultClassFilter filter = new ClassChooser.DefaultClassFilter();
        filter.setIncludeInterfaces(false);
        filter.setIncludeAbstractClasses(false);
        filter.setIncludeConcreteClasses(true);
        filter.setIncludeInnerClasses(false);
        filter.setIncludeInnerStaticClasses(true);
        filter.setIncludeNonMainClasses(true);
        filter.setIncludeNonDefaultConstructorClasses(true);
        filter.setIncludeNonPublicConstructorClasses(false);
        this.setClassFilter(filter);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        if (this.itemListeners == null) {
            return;
        }
        this.itemListeners.itemStateChanged(e);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        logger.fine("addItemListener: " + listener);
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        logger.fine("removeItemListener: " + listener);
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners((EventListener)this.itemListeners, ItemListener.class);
    }

    public Class getSelectedBeanType() throws Exception {
        ClassDescriptor descr = this.getClassChooser().getSelectedClassDescriptor();
        if (descr != null) {
            String className = descr.getClassName();
            return this.getClassRegistry().getClass(className);
        }
        return null;
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        Constructor cons = this.getSelectedConstructor();
        if (cons == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = cons;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshConstructors() throws Exception {
        if (this.refreshing) {
            return;
        }
        if (this.refreshingParams) {
            return;
        }
        logger.fine("refreshConstructors...");
        try {
            Constructor<?>[] constr;
            this.refreshing = true;
            this.getJComboBoxConstructor().removeAllItems();
            Class type = this.getSelectedBeanType();
            if (type != null && (constr = type.getConstructors()) != null) {
                TreeSet sort = new TreeSet(new ConstructorComparator());
                for (int c = constr.length - 1; c >= 0; --c) {
                    sort.add(constr[c]);
                }
                for (Constructor constructor : sort) {
                    this.getJComboBoxConstructor().addItem(constructor);
                }
            }
        }
        finally {
            this.refreshing = false;
        }
        logger.fine("refreshConstructors.exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshParameters() {
        logger.fine("refreshParameters...");
        try {
            this.refreshingParams = true;
            Constructor constr = this.getSelectedConstructor();
            Property[] paramProps = null;
            if (constr != null) {
                Class<?>[] paramTypes = constr.getParameterTypes();
                paramProps = new Property[paramTypes.length];
                for (int c = 0; c < paramTypes.length; ++c) {
                    Class<?> paramType = paramTypes[c];
                    String paramName = "param" + c;
                    Object paramValue = null;
                    boolean nullable = true;
                    DefaultProperty prop = new DefaultProperty(paramName, paramType, paramValue, true, true, nullable);
                    paramProps[c] = prop;
                }
            }
            this.paramProperties = paramProps;
            logger.fine("refreshParameters: " + paramProps);
            this.getPropertyPageParams().setProperties(paramProps);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.refreshingParams = false;
        }
        logger.fine("refreshParameters.exit");
    }

    protected void fireSelectionChanged() {
        ItemEvent ev = new ItemEvent(this, 701, null, 701);
        this.fireItemStateChanged(ev);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setMinimumSize(new Dimension(203, 74));
            this.jPanel.add((Component)this.getClassChooser(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 4;
            gridBagConstraints1.insets = new Insets(0, 4, 4, 4);
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            JLabel jLabel2 = new JLabel();
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            JLabel jLabel1 = new JLabel();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setMinimumSize(new Dimension(150, 137));
            this.jPanel1.setPreferredSize(new Dimension(300, 200));
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.gridy = 0;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.insets = new Insets(4, 4, 4, 4);
            jLabel1.setText("Constructor:");
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.gridy = 1;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.fill = 2;
            gridBagConstraints23.insets = new Insets(0, 4, 0, 4);
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.gridy = 2;
            gridBagConstraints24.anchor = 17;
            gridBagConstraints24.insets = new Insets(4, 4, 4, 4);
            jLabel2.setText("Parameters:");
            this.jPanel1.add((Component)jLabel1, gridBagConstraints22);
            this.jPanel1.add((Component)this.getJComboBoxConstructor(), gridBagConstraints23);
            this.jPanel1.add((Component)jLabel2, gridBagConstraints24);
            this.jPanel1.add((Component)this.getJButtonCreate(), gridBagConstraints1);
            this.jPanel1.add((Component)this.getPropertyPageParams(), gridBagConstraints2);
        }
        return this.jPanel1;
    }

    private JComboBox getJComboBoxConstructor() {
        if (this.jComboBoxConstructor == null) {
            this.jComboBoxConstructor = new JComboBox();
            this.jComboBoxConstructor.setOpaque(false);
            this.jComboBoxConstructor.addItemListener(new ItemListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(ItemEvent e) {
                    logger.fine("itemStateChanged: " + e);
                    if (NewObjectPanel.this.refreshing) {
                        return;
                    }
                    try {
                        NewObjectPanel.this.refreshing = true;
                        NewObjectPanel.this.refreshParameters();
                        NewObjectPanel.this.refreshing = true;
                        NewObjectPanel.this.fireSelectionChanged();
                    }
                    finally {
                        NewObjectPanel.this.refreshing = false;
                    }
                }
            });
        }
        return this.jComboBoxConstructor;
    }

    public Object[] getParameterValues() throws Exception {
        int num = this.paramProperties == null ? 0 : this.paramProperties.length;
        Object[] rc = new Object[num];
        for (int c = 0; c < num; ++c) {
            Property prop = this.paramProperties[c];
            rc[c] = prop == null ? null : prop.getValue();
        }
        return rc;
    }

    private ClassChooser getClassChooser() {
        if (this.classChooser == null) {
            this.classChooser = new ClassChooser();
            this.classChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewObjectPanel.this.handleClassChooserAction();
                }
            });
            this.classChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewObjectPanel.this.handleClassChooserSelected();
                }
            });
        }
        return this.classChooser;
    }

    public ClassRegistry getClassRegistry() {
        if (this.classRegistry == null) {
            this.setClassRegistry(Platform.getInstance().getClassRegistry());
        }
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
        this.getClassChooser().setClassRegistry(classRegistry);
    }

    protected void handleClassChooserSelected() {
        logger.fine("Selection changed..");
        try {
            this.refreshConstructors();
            this.refreshParameters();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void handleClassChooserAction() {
        logger.fine("ACTION..");
    }

    private JButton getJButtonCreate() {
        if (this.jButtonCreate == null) {
            this.jButtonCreate = new JButton();
            this.jButtonCreate.setText("Create");
            this.jButtonCreate.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/newaccessbean_wiz.gif")));
            this.jButtonCreate.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewObjectPanel.this.actionCreate();
                }
            });
        }
        return this.jButtonCreate;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOpaque(false);
            this.jSplitPane.setLeftComponent(this.getJPanel());
            this.jSplitPane.setRightComponent(this.getJPanel1());
        }
        return this.jSplitPane;
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    protected void actionCreate() {
        ActionEvent ev = new ActionEvent(this, 1001, "create");
        this.fireActionPerformed(ev);
    }

    public Filter getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Filter classFilter) {
        this.classFilter = classFilter;
        this.getClassChooser().setClassFilter(classFilter);
    }

    public int getEmptySearchAction() {
        return this.emptySearchAction;
    }

    public void setEmptySearchAction(int emptySearchAction) {
        this.emptySearchAction = emptySearchAction;
        this.getClassChooser().setEmptySearchAction(emptySearchAction);
        if (emptySearchAction == ClassChooser.EMPTY_SEARCH_ALL) {
            this.getClassChooser().refresh();
        }
    }

    private PropertyPage getPropertyPageParams() {
        if (this.propertyPageParams == null) {
            this.propertyPageParams = new PropertyPage();
        }
        return this.propertyPageParams;
    }

    protected static class ConstructorComparator
    implements Comparator {
        protected ConstructorComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Constructor cons0 = (Constructor)arg0;
            Constructor cons1 = (Constructor)arg1;
            Class<?>[] params0 = cons0.getParameterTypes();
            Class<?>[] params1 = cons1.getParameterTypes();
            int pnum = Math.min(params0.length, params1.length);
            for (int i = 0; i < pnum; ++i) {
                String pc2;
                String pc1 = params0[i].getName();
                int cmp = pc1.compareTo(pc2 = params1[i].getName());
                if (cmp == 0) continue;
                return cmp;
            }
            return params0.length < params1.length ? -1 : 1;
        }
    }
}

