/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.components.PropertyField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ViewportLayout;

public class PropertyPage
extends JPanel {
    private static final long serialVersionUID = 5422373677627142247L;
    private List properties;
    private Map propertyChangeHandlers;
    private BeansToolkit beansToolkit;
    private boolean editable;
    private boolean checkable;
    private List checkboxes;
    private int iconKind;
    private Insets labelInsets = new Insets(2, 4, 2, 4);
    private Insets editorInsets = new Insets(2, 0, 2, 4);
    private KeyHandler keyHandler = new KeyHandler();
    private List propertyFields;
    private JScrollPane jScrollPane = null;
    private JPanel propertiesPanel;
    private boolean autoApply = true;
    private boolean refreshing = false;
    private static final Logger logger = Logger.getLogger(PropertyPage.class.getName());

    public PropertyPage() {
        this.initialize();
        this.initPropertyPage();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(376, 258));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
        }
        return this.jScrollPane;
    }

    protected void initPropertyPage() {
        this.iconKind = 1;
        this.editable = true;
        this.properties = new ArrayList();
        this.propertyChangeHandlers = new HashMap();
        this.propertyFields = new ArrayList();
        this.checkboxes = new ArrayList();
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.getJScrollPane().setHorizontalScrollBarPolicy(31);
        this.getJScrollPane().setVerticalScrollBarPolicy(20);
        this.getJScrollPane().getViewport().setLayout(new PropertiesViewportLayout());
        this.getJScrollPane().setViewportView(this.propertiesPanel);
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public void addProperty(Property p) {
        this.addProperty(this.properties.size(), p);
    }

    public void addProperty(int index, Property p) {
        if (p == null) {
            return;
        }
        this.properties.add(index, p);
        PropertyChangeHandler handler = new PropertyChangeHandler(p);
        this.propertyChangeHandlers.put(p, handler);
        p.addPropertyChangeListener((PropertyChangeListener)handler);
        this.refresh();
    }

    public void setProperties(Property[] p) {
        Iterator i = this.properties.iterator();
        while (i.hasNext()) {
            Property z = (Property)i.next();
            PropertyChangeHandler handler = (PropertyChangeHandler)this.propertyChangeHandlers.remove(z);
            if (handler != null) {
                z.removePropertyChangeListener((PropertyChangeListener)handler);
            }
            i.remove();
        }
        int num = p == null ? 0 : p.length;
        for (int i2 = 0; i2 < num; ++i2) {
            Property x = p[i2];
            if (x == null) continue;
            this.properties.add(x);
            PropertyChangeHandler handler = new PropertyChangeHandler(x);
            this.propertyChangeHandlers.put(x, handler);
            x.addPropertyChangeListener((PropertyChangeListener)handler);
        }
        logger.fine("refreshing properties: " + num);
        this.refresh();
    }

    public void removeProperty(Property p) {
        if (this.properties.remove(p)) {
            PropertyChangeHandler handler = (PropertyChangeHandler)this.propertyChangeHandlers.remove(p);
            if (handler != null) {
                p.removePropertyChangeListener((PropertyChangeListener)handler);
            }
            this.refresh();
        }
    }

    public void removeAllProperties() {
        Iterator i = this.properties.iterator();
        while (i.hasNext()) {
            Property p = (Property)i.next();
            PropertyChangeHandler handler = (PropertyChangeHandler)this.propertyChangeHandlers.remove(p);
            if (handler != null) {
                p.removePropertyChangeListener((PropertyChangeListener)handler);
            }
            i.remove();
        }
        this.refresh();
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Property getPropertyAt(int index) {
        return (Property)this.properties.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        if (this.refreshing) {
            return;
        }
        try {
            GridBagConstraints gbc;
            this.refreshing = true;
            this.propertyFields.clear();
            this.checkboxes.clear();
            BeansToolkit btk = this.beansToolkit;
            JPanel pan = this.propertiesPanel;
            pan.removeAll();
            int index = 0;
            for (Property p : this.properties) {
                try {
                    Class<?> type;
                    String name = p.getName();
                    String typeName = null;
                    Icon typeIcon = null;
                    PropertyDescriptor pd = p.getDescriptor();
                    if (btk != null && pd != null && (type = pd.getPropertyType()) != null) {
                        typeName = type.getName();
                        typeIcon = btk.getIcon(type, this.iconKind);
                        if (typeIcon == null) {
                            typeIcon = btk.getDefaultIcon(this.iconKind);
                        }
                    }
                    JLabel iconLabel = new JLabel();
                    iconLabel.setToolTipText(typeName);
                    iconLabel.setIcon(typeIcon);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = index;
                    gbc.anchor = 18;
                    gbc.fill = 1;
                    gbc.weightx = 0.0;
                    gbc.insets = this.labelInsets;
                    pan.add((Component)iconLabel, gbc);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = index;
                    gbc.anchor = 18;
                    gbc.fill = 1;
                    gbc.weightx = 0.0;
                    gbc.insets = this.labelInsets;
                    JLabel label = new JLabel(name);
                    label.setFocusable(false);
                    label.setToolTipText(typeName);
                    pan.add((Component)label, gbc);
                    if (this.checkable) {
                        JCheckBox check = new JCheckBox();
                        check.setFocusable(false);
                        check.setEnabled(false);
                        check.setToolTipText(name);
                        check.setMargin(new Insets(0, 0, 0, 0));
                        check.addItemListener(new CheckBoxItemHandler(p));
                        gbc = new GridBagConstraints();
                        gbc.gridx = 2;
                        gbc.gridy = index;
                        gbc.anchor = 18;
                        gbc.fill = 1;
                        gbc.weightx = 0.0;
                        gbc.insets = this.labelInsets;
                        pan.add((Component)check, gbc);
                        this.checkboxes.add(check);
                    }
                    PropertyField field = new PropertyField();
                    field.setBeansToolkit(btk);
                    field.setEditable(true);
                    field.setProperty(p);
                    field.addKeyListener(this.keyHandler);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 3;
                    gbc.gridy = index;
                    gbc.anchor = 18;
                    gbc.fill = 1;
                    gbc.weightx = 1.0;
                    gbc.insets = this.editorInsets;
                    logger.fine("DEBUG: setProperty[2]: " + p.getName() + " (" + p.getDescriptor().getPropertyType() + ") = " + p.getValue());
                    pan.add((Component)field, gbc);
                    logger.fine("DEBUG: setProperty[3]: " + p.getName());
                    this.propertyFields.add(field);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                ++index;
            }
            JPanel bottom = new JPanel();
            bottom.setOpaque(false);
            bottom.setPreferredSize(new Dimension(0, 0));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = index;
            gbc.fill = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            pan.add((Component)bottom, gbc);
            logger.fine("DEBUG: repaint..");
            this.validate();
            this.repaint();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.refreshing = false;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Insets getEditorInsets() {
        return this.editorInsets;
    }

    public void setEditorInsets(Insets editorInsets) {
        this.editorInsets = editorInsets;
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets labelInsets) {
        this.labelInsets = labelInsets;
    }

    protected void switchFocusUp(PropertyField pf) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocusBackward();
        }
    }

    protected void switchFocusDown(PropertyField pf) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocus();
        }
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void setCheckable(boolean newCheckable) {
        if (this.checkable == newCheckable) {
            return;
        }
        this.checkable = newCheckable;
        this.refresh();
    }

    protected void handlePropertyChange(Property p, PropertyChangeEvent ev) {
        JCheckBox check;
        int index = this.properties.indexOf(p);
        if (index < 0) {
            return;
        }
        int size = this.checkboxes.size();
        if (index < size && !(check = (JCheckBox)this.checkboxes.get(index)).isSelected()) {
            check.setSelected(true);
        }
    }

    public boolean isPropertyChecked(Property p) {
        int index = this.properties.indexOf(p);
        if (index < 0) {
            return false;
        }
        int size = this.checkboxes.size();
        if (index < size) {
            JCheckBox check = (JCheckBox)this.checkboxes.get(index);
            return check.isSelected();
        }
        return false;
    }

    public void setPropertyChecked(Property p, boolean checked) {
        int index = this.properties.indexOf(p);
        if (index < 0) {
            return;
        }
        int size = this.checkboxes.size();
        if (index < size) {
            JCheckBox check = (JCheckBox)this.checkboxes.get(index);
            check.setSelected(checked);
        }
    }

    protected void handleCheckBoxItemStateChanged(Property property, ItemEvent e) {
        int index = this.properties.indexOf(property);
        if (index < 0) {
            return;
        }
        int size = this.checkboxes.size();
        if (index < size) {
            JCheckBox check = (JCheckBox)this.checkboxes.get(index);
            PropertyField field = (PropertyField)this.propertyFields.get(index);
            if (check.isSelected()) {
                field.requestFocus();
            } else {
                field.refresh();
            }
        }
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public void setAutoApply(boolean autoApply) {
        this.autoApply = autoApply;
    }

    protected class CheckBoxItemHandler
    implements ItemListener {
        private Property property;

        public CheckBoxItemHandler(Property property) {
            this.property = property;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            PropertyPage.this.handleCheckBoxItemStateChanged(this.property, e);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private Property property;

        public PropertyChangeHandler(Property property) {
            this.property = property;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyPage.this.handlePropertyChange(this.property, evt);
        }
    }

    protected class PropertiesViewportLayout
    extends ViewportLayout {
        private static final long serialVersionUID = -379563785975659695L;

        protected PropertiesViewportLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            Scrollable scrollableView = null;
            if (view == null) {
                return;
            }
            if (view instanceof Scrollable) {
                scrollableView = (Scrollable)((Object)view);
            }
            vp.getInsets();
            Dimension viewPrefSize = view.getPreferredSize();
            Dimension vpSize = vp.getSize();
            Dimension extentSize = vp.toViewCoordinates(vpSize);
            Dimension viewSize = new Dimension(viewPrefSize);
            if (scrollableView != null) {
                if (scrollableView.getScrollableTracksViewportWidth()) {
                    viewSize.width = vpSize.width;
                }
                if (scrollableView.getScrollableTracksViewportHeight()) {
                    viewSize.height = vpSize.height;
                }
            }
            Point viewPosition = vp.getViewPosition();
            if (scrollableView == null || vp.getParent() == null || vp.getParent().getComponentOrientation().isLeftToRight()) {
                if (viewPosition.x + extentSize.width > viewSize.width) {
                    viewPosition.x = Math.max(0, viewSize.width - extentSize.width);
                }
            } else {
                viewPosition.x = extentSize.width > viewSize.width ? viewSize.width - extentSize.width : Math.max(0, Math.min(viewSize.width - extentSize.width, viewPosition.x));
            }
            if (viewPosition.y + extentSize.height > viewSize.height) {
                viewPosition.y = Math.max(0, viewSize.height - extentSize.height);
            }
            if (scrollableView == null) {
                if (viewPosition.x == 0 && vpSize.width > viewPrefSize.width) {
                    viewSize.width = vpSize.width;
                }
                if (viewPosition.y == 0 && vpSize.height > viewPrefSize.height) {
                    viewSize.height = vpSize.height;
                }
            }
            if (viewPosition.x == 0 && viewPrefSize.width > vpSize.width) {
                viewSize.width = vpSize.width;
            }
            vp.setViewPosition(viewPosition);
            vp.setViewSize(viewSize);
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            int code = e.getKeyCode();
            switch (code) {
                case 38: {
                    PropertyField field;
                    Component editor;
                    Component comp = e.getComponent();
                    e.consume();
                    if (comp == null || !(comp instanceof PropertyField) || (editor = (field = (PropertyField)comp).getEditorComponent()) == null) break;
                    if (editor instanceof JComboBox) {
                        return;
                    }
                    PropertyPage.this.switchFocusUp(field);
                    break;
                }
                case 40: {
                    PropertyField field;
                    Component editor;
                    Component comp = e.getComponent();
                    e.consume();
                    if (comp == null || !(comp instanceof PropertyField) || (editor = (field = (PropertyField)comp).getEditorComponent()) == null) break;
                    if (editor instanceof JComboBox) {
                        return;
                    }
                    PropertyPage.this.switchFocusDown(field);
                    break;
                }
            }
        }
    }
}

