/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Sys;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.AnchorlessBeanContext;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.beans.TypeContext;
import com.spacekiller.util.beans.components.BeanListCellRenderer;
import com.spacekiller.util.beans.components.FeatureLabelToolkit;
import com.spacekiller.util.beans.customizers.AbstractCustomizer;
import com.spacekiller.util.beans.customizers.BeanSelectionContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.beancontext.BeanContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MapCustomizer
extends AbstractCustomizer
implements Customizer {
    private static final long serialVersionUID = -3650401881050920270L;
    private BeansToolkit beansToolkit;
    private BeanSelectionContext beanSelectionContext;
    private ListSelectionListener listSelectionListener;
    private TableCellRenderer tableCellRenderer;
    private Map map;
    private boolean sortTable;
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private DefaultDragSourceHandler dragSourceHandler = new DefaultDragSourceHandler();
    private DropTargetHandler dropTargetHandler = new DropTargetHandler();
    private DropBeanContext dropBeanContext;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JToolBar jToolBar = null;
    private JButton jButtonRefresh = null;
    private JPanel jPanel1 = null;
    private JButton jButtonPaste = null;
    private JPanel jPanel2 = null;
    private JButton jButtonRemove = null;
    private static final Logger logger = Logger.getLogger(MapCustomizer.class.getName());

    public MapCustomizer() {
        this.initialize();
        this.initMapCustomizer();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(298, 237));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJToolBar(), gridBagConstraints11);
    }

    @Override
    public void setObject(Object bean) {
        this.setMap((Map)bean);
    }

    @Override
    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            return super.getBeansToolkit();
        }
        return this.beansToolkit;
    }

    @Override
    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        if (beansToolkit != null) {
            FeatureLabelToolkit flt = new FeatureLabelToolkit();
            final BeanListCellRenderer listRenderer = new BeanListCellRenderer(beansToolkit, flt);
            TableCellRenderer renderer = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return listRenderer.getListCellRendererComponent((JList)null, value, row, isSelected, hasFocus);
                }
            };
            TableColumnModel columnModel = this.getJTable().getColumnModel();
            DefaultTableColumnModel newColModel = new DefaultTableColumnModel();
            int cols = columnModel.getColumnCount();
            for (int i = 0; i < cols; ++i) {
                TableColumn col = columnModel.getColumn(i);
                col.setCellRenderer(renderer);
                newColModel.addColumn(col);
            }
            this.getJTable().setColumnModel(newColModel);
            this.tableCellRenderer = renderer;
        }
    }

    @Override
    public BeanSelectionContext getBeanSelectionContext() {
        return this.beanSelectionContext;
    }

    @Override
    public void setBeanSelectionContext(BeanSelectionContext beanSelectionContext) {
        this.beanSelectionContext = beanSelectionContext;
    }

    @Override
    public ListSelectionListener getListSelectionListener() {
        return this.listSelectionListener;
    }

    @Override
    public void setListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionListener = listSelectionListener;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
        }
        return this.jTable;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
        this.sortTable = false;
        if (map != null && !(map instanceof SortedMap)) {
            this.sortTable = true;
        }
        this.refresh();
    }

    protected void initMapCustomizer() {
        this.checkEnable();
        this.setBeansToolkit(this.getBeansToolkit());
        this.setPreferredSize(new Dimension(400, 300));
        JTable table = this.getJTable();
        table.setAutoCreateColumnsFromModel(false);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn columnKey = new TableColumn(0);
        columnKey.setHeaderValue("Key");
        columnKey.setCellRenderer(this.tableCellRenderer);
        columnModel.addColumn(columnKey);
        TableColumn columnValue = new TableColumn(1);
        columnValue.setHeaderValue("Value");
        columnValue.setCellRenderer(this.tableCellRenderer);
        columnModel.addColumn(columnValue);
        table.setColumnModel(columnModel);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MapCustomizer.this.checkEnable();
            }
        });
        DragSource ds = new DragSource();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 0x40000003;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(this.getJTable(), actions, this.dragGestureHandler);
        dgr.getComponent();
        DropTarget dt = new DropTarget(table, this.dropTargetHandler);
        table.setDropTarget(dt);
        JScrollPane sp = this.getJScrollPane();
        DropTarget dt2 = new DropTarget(sp, this.dropTargetHandler);
        sp.setDropTarget(dt2);
    }

    protected JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setOpaque(false);
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getJButtonRefresh());
            this.jToolBar.add(this.getJPanel1());
            this.jToolBar.add(this.getJButtonPaste());
            this.jToolBar.add(this.getJPanel2());
            this.jToolBar.add(this.getJButtonRemove());
        }
        return this.jToolBar;
    }

    private JButton getJButtonRefresh() {
        if (this.jButtonRefresh == null) {
            this.jButtonRefresh = new JButton();
            this.jButtonRefresh.setToolTipText("Refresh list");
            this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/refresh_view.gif")));
            this.jButtonRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCustomizer.this.refresh();
                }
            });
        }
        return this.jButtonRefresh;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setMaximumSize(new Dimension(8, 8));
            this.jPanel1.setPreferredSize(new Dimension(8, 8));
            this.jPanel1.setOpaque(false);
            this.jPanel1.setMinimumSize(new Dimension(8, 8));
        }
        return this.jPanel1;
    }

    private JButton getJButtonPaste() {
        if (this.jButtonPaste == null) {
            this.jButtonPaste = new JButton();
            this.jButtonPaste.setToolTipText("Paste new element(s)");
            this.jButtonPaste.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/paste.gif")));
            this.jButtonPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCustomizer.this.actionPaste();
                }
            });
        }
        return this.jButtonPaste;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setMaximumSize(new Dimension(8, 8));
            this.jPanel2.setPreferredSize(new Dimension(8, 8));
            this.jPanel2.setOpaque(false);
            this.jPanel2.setMinimumSize(new Dimension(8, 8));
        }
        return this.jPanel2;
    }

    private JButton getJButtonRemove() {
        if (this.jButtonRemove == null) {
            this.jButtonRemove = new JButton();
            this.jButtonRemove.setToolTipText("Remove selected element(s)");
            this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/error2.gif")));
            this.jButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCustomizer.this.actionRemove();
                }
            });
        }
        return this.jButtonRemove;
    }

    protected void checkEnable() {
        int[] sel = this.getJTable().getSelectedRows();
        boolean enableRemove = sel.length > 0;
        this.getJButtonRemove().setEnabled(enableRemove);
    }

    public void refresh() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Key");
        model.addColumn("Value");
        TreeMap m = this.getMap();
        if (m != null) {
            if (this.sortTable) {
                try {
                    TreeMap tree = new TreeMap(new MapKeyComparator());
                    tree.putAll(m);
                    m = tree;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            for (Map.Entry me : m.entrySet()) {
                Object key = me.getKey();
                Object value = me.getValue();
                model.addRow(new Object[]{key, value});
            }
        }
        this.getJTable().setModel(model);
        this.checkEnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionPaste() {
        Map map = this.getMap();
        if (map == null) {
            return;
        }
        BeansToolkit btk = this.getBeansToolkit();
        if (btk == null) {
            return;
        }
        try {
            AbstractBeansToolkit abt = (AbstractBeansToolkit)btk;
            ClipboardManager cm = abt.getClipboardManager();
            if (cm == null) {
                return;
            }
            Collection objects = cm.getObjects();
            if (objects == null) {
                return;
            }
            if (objects.isEmpty()) {
                return;
            }
            try {
                for (Object obj : objects) {
                    if (map.containsKey(obj)) continue;
                    map.put(obj, null);
                }
            }
            finally {
                this.refresh();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionRemove() {
        Map map = this.getMap();
        if (map == null) {
            return;
        }
        int[] sel = this.getJTable().getSelectedRows();
        if (sel.length < 1) {
            return;
        }
        try {
            TableModel model = this.getJTable().getModel();
            for (int i = 0; i < sel.length; ++i) {
                int row = sel[i];
                Object key = model.getValueAt(row, 0);
                Object value = model.getValueAt(row, 1);
                if (map.get(key) != value) continue;
                map.remove(key);
            }
        }
        finally {
            this.refresh();
        }
    }

    public TableCellRenderer getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public void setTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    private void handleException(Throwable exception) {
        this.handleCustomizerException(exception);
    }

    protected BeanContext getTargetBeanContext(int x, int y) {
        Point p = new Point(x, y);
        int row = this.getJTable().rowAtPoint(p);
        int col = this.getJTable().columnAtPoint(p);
        if (col < 0 && row < 0) {
            col = 0;
        }
        if (col < 0) {
            return null;
        }
        if (col == 1 && row < 0) {
            return null;
        }
        if (this.dropBeanContext == null) {
            this.dropBeanContext = new DropBeanContext();
        }
        this.dropBeanContext.setRow(row);
        this.dropBeanContext.setColumn(col);
        this.dropBeanContext.setSupportedType(Object.class);
        return this.dropBeanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean drop(int row, int col, Object targetChild) {
        Map map = this.getMap();
        if (col == 0 || row < 0) {
            Object key = targetChild;
            if (map.containsKey(key)) {
                return false;
            }
            try {
                map.put(key, null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.refresh();
                this.setSelectedKey(key);
            }
        }
        if (col == 1) {
            Object value = targetChild;
            TableModel model = this.getJTable().getModel();
            Object key = model.getValueAt(row, 0);
            try {
                map.put(key, value);
                boolean bl = true;
                return bl;
            }
            finally {
                this.refresh();
                this.setSelectedKey(key);
            }
        }
        return false;
    }

    protected void setSelectedKey(Object key) {
        TableModel model = this.getJTable().getModel();
        int found = -1;
        int rows = model.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Object k = model.getValueAt(i, 0);
            if (k == key) {
                found = i;
                break;
            }
            if (k == null || !k.equals(key)) continue;
            found = i;
            break;
        }
        this.getJTable().getSelectionModel().setSelectionInterval(found, found);
    }

    protected static class MapKeyComparator
    implements Comparator {
        protected MapKeyComparator() {
        }

        public int compare(Object a, Object b) {
            int bh;
            String sb;
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return b == null ? 0 : -1;
            }
            if (b == null) {
                return 1;
            }
            String sa = a.toString();
            int rc = sa.compareTo(sb = b.toString());
            if (rc != 0) {
                return rc;
            }
            int ah = System.identityHashCode(a);
            return ah < (bh = System.identityHashCode(b)) ? -1 : 1;
        }
    }

    protected class DropBeanContext
    extends AnchorlessBeanContext
    implements TypeContext {
        private static final long serialVersionUID = -3662150009368447250L;
        private Set supportedTypes = new HashSet();
        private int row;
        private int column;

        public Iterator getSupportedTypes() {
            return this.supportedTypes.iterator();
        }

        public boolean supports(Class type) {
            if (this.supportedTypes.contains(type)) {
                return true;
            }
            for (Class clazz : this.supportedTypes) {
                if (!clazz.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }

        public boolean supports(Object bean) {
            return this.supports(bean.getClass());
        }

        public boolean add(Object targetChild) {
            if (targetChild == null) {
                return false;
            }
            if (!this.supports(targetChild)) {
                return false;
            }
            return MapCustomizer.this.drop(this.row, this.column, targetChild);
        }

        protected void setSupportedTypes(Set supportedTypes) {
            this.supportedTypes = supportedTypes;
        }

        protected void setSupportedType(Class type) {
            this.supportedTypes.clear();
            this.supportedTypes.add(type);
        }

        public int getColumn() {
            return this.column;
        }

        protected void setColumn(int column) {
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        protected void setRow(int row) {
            this.row = row;
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            BeanDropSupport bds = MapCustomizer.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = MapCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            this.dropBeans.clear();
            if (target != null) {
                bds.enumerateDropBeans(target, dtde, this.dropBeans);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            BeanDropSupport bds = MapCustomizer.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = MapCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            if (target == null) {
                dtde.rejectDrag();
                return;
            }
            ArrayList temp = new ArrayList();
            boolean searchSuccess = bds.enumerateDropBeans(target, dtde, temp);
            if (target != null && searchSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                for (Object o : this.dropBeans) {
                    if (o == null || !bds.acceptDropBean(target, o)) continue;
                    accepted = true;
                    break;
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            BeanDropSupport bds = MapCustomizer.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Point pos = dtde.getLocation();
            BeanContext target = MapCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            Sys.println((String)(" - Drop target context: " + target));
            ArrayList temp = new ArrayList();
            boolean enumSuccess = bds.enumerateDropBeans(target, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            Sys.println((String)(" - Drop beans: " + this.dropBeans.size()));
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                if (target != null) {
                    try {
                        Sys.println((String)" - Drop beans..");
                        bds.dropBeans(this.dropBeans, target, dropAction);
                        Sys.println((String)" - Drop completed.");
                        dtde.dropComplete(true);
                        this.dropBeans.clear();
                        return;
                    }
                    catch (Exception e) {
                        MapCustomizer.this.handleException(e);
                    }
                } else {
                    Sys.println((String)"DEBUG: drop target is null!");
                }
            }
            Sys.println((String)" - Drop failed!");
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            ArrayList<Object> beans = new ArrayList<Object>();
            int[] rows = MapCustomizer.this.getJTable().getSelectedRows();
            int[] cols = MapCustomizer.this.getJTable().getSelectedColumns();
            TableModel model = MapCustomizer.this.getJTable().getModel();
            if (model == null) {
                return;
            }
            int columns = model.getColumnCount();
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                if (cols.length < 1) {
                    for (int c = 0; c < columns; ++c) {
                        Object obj = model.getValueAt(row, c);
                        beans.add(obj);
                    }
                    continue;
                }
                for (int k = 0; k < cols.length; ++k) {
                    int col = cols[k];
                    Object obj = model.getValueAt(row, col);
                    beans.add(obj);
                }
            }
            if (beans.isEmpty()) {
                return;
            }
            MapCustomizer.this.dragSourceHandler.setBeanDropSupport(MapCustomizer.this.getBeanDropSupport());
            MapCustomizer.this.dragSourceHandler.startDrag(dge, beans);
        }
    }
}

