/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.editors.AbstractPropertyFeatureEditor;
import com.spacekiller.util.beans.editors.ComplexPropertyEditor;
import com.spacekiller.util.beans.editors.DefaultComplexCustomEditor;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Iterator;

public class CollectionPropertyEditor
extends AbstractPropertyFeatureEditor
implements ComplexPropertyEditor {
    private Class elementType = Object.class;

    public CollectionPropertyEditor() {
    }

    public CollectionPropertyEditor(Class elementType) {
        this();
        this.setElementType(elementType);
    }

    @Override
    public void addElement(Object element) {
        Collection col = this.getCollection();
        if (col == null) {
            try {
                col = this.createCollection();
            }
            catch (Exception e) {
                throw new RuntimeException("" + e);
            }
        }
        if (col != null) {
            col.add(element);
        }
    }

    protected Collection createCollection() throws Exception {
        return (Collection)Tools.newInstance((Class)this.getCollectionType());
    }

    @Override
    public Object createElement() throws Exception {
        return super.createElement(this.getElementType());
    }

    public Collection getCollection() {
        return (Collection)this.getValue();
    }

    protected Class getCollectionType() {
        FeatureDescriptor feature = this.getFeatureDescriptor();
        if (feature == null) {
            return null;
        }
        PropertyDescriptor property = (PropertyDescriptor)feature;
        return property.getPropertyType();
    }

    @Override
    public Component getCustomEditor() {
        DefaultComplexCustomEditor custom = new DefaultComplexCustomEditor();
        custom.setPropertyEditor(this);
        return custom;
    }

    @Override
    public Object getElementAt(int i) {
        throw new RuntimeException("Method not supported!");
    }

    @Override
    public int getElementCount() {
        Collection col = this.getCollection();
        return col == null ? 0 : col.size();
    }

    @Override
    public Iterator getElements() {
        Collection col = this.getCollection();
        return col == null ? null : col.iterator();
    }

    @Override
    public void getElements(Collection dst) {
        Collection col = this.getCollection();
        if (col != null) {
            col.addAll(dst);
        }
    }

    public Class getElementType() {
        return this.elementType;
    }

    @Override
    public void insertElementAt(Object element, int i) {
        throw new RuntimeException("Method not supported!");
    }

    @Override
    public void removeElement(Object element) {
        Collection col = this.getCollection();
        if (col != null) {
            col.remove(element);
        }
    }

    @Override
    public void removeElementAt(int i) {
        throw new RuntimeException("Method not supported!");
    }

    @Override
    public void setElementAt(Object element, int i) {
        throw new RuntimeException("Method not supported!");
    }

    protected void setElementType(Class newCollectionElementType) {
        this.elementType = newCollectionElementType;
    }

    @Override
    public boolean supportsAddElement() {
        return true;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public boolean supportsGetElementAt() {
        return false;
    }

    @Override
    public boolean supportsInsertElementAt() {
        return false;
    }

    @Override
    public boolean supportsRemoveElement() {
        return true;
    }

    @Override
    public boolean supportsRemoveElementAt() {
        return false;
    }

    @Override
    public boolean supportsSetElementAt() {
        return false;
    }
}

