/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.editors.ListModelPropertyEditor;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import javax.swing.DefaultListModel;

public class DefaultListModelPropertyEditor
extends ListModelPropertyEditor {
    private Class elementType = Object.class;

    public DefaultListModelPropertyEditor() {
    }

    public DefaultListModelPropertyEditor(Class newElementType) {
        this();
        this.setElementType(newElementType);
    }

    @Override
    public void addElement(Object element) {
        DefaultListModel model = this.getDefaultListModel();
        if (model == null) {
            try {
                model = this.createDefaultListModel();
            }
            catch (Exception e) {
                throw new RuntimeException("" + e);
            }
        }
        if (model != null) {
            model.addElement(element);
        }
    }

    protected DefaultListModel createDefaultListModel() throws Exception {
        return (DefaultListModel)Tools.newInstance((Class)this.getDefaultListModelType());
    }

    @Override
    public Object createElement() throws Exception {
        return super.createElement(this.getElementType());
    }

    public DefaultListModel getDefaultListModel() {
        return (DefaultListModel)this.getValue();
    }

    protected Class getDefaultListModelType() {
        FeatureDescriptor feature = this.getFeatureDescriptor();
        if (feature == null) {
            return null;
        }
        PropertyDescriptor property = (PropertyDescriptor)feature;
        return property.getPropertyType();
    }

    public Class getElementType() {
        return this.elementType;
    }

    @Override
    public void insertElementAt(Object element, int i) {
        DefaultListModel model = this.getDefaultListModel();
        if (model == null) {
            try {
                model = this.createDefaultListModel();
            }
            catch (Exception e) {
                throw new RuntimeException("" + e);
            }
        }
        if (model != null) {
            model.insertElementAt(element, i);
        }
    }

    @Override
    public void removeElement(Object element) {
        DefaultListModel model = this.getDefaultListModel();
        if (model != null) {
            model.removeElement(element);
        }
    }

    @Override
    public void removeElementAt(int i) {
        this.getDefaultListModel().removeElementAt(i);
    }

    @Override
    public void setElementAt(Object element, int i) {
        this.getDefaultListModel().setElementAt(element, i);
    }

    protected void setElementType(Class newElementType) {
        this.elementType = newElementType;
    }

    @Override
    public boolean supportsAddElement() {
        return true;
    }

    @Override
    public boolean supportsInsertElementAt() {
        return true;
    }

    @Override
    public boolean supportsRemoveElement() {
        return true;
    }

    @Override
    public boolean supportsRemoveElementAt() {
        return true;
    }

    @Override
    public boolean supportsSetElementAt() {
        return true;
    }
}

