/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.Data;
import java.beans.PropertyEditorSupport;

public class HexPropertyEditor
extends PropertyEditorSupport {
    private static final String hexChars = "0123456789ABCDEF";

    protected Number convertHex2Number(String hex) {
        if (hex == null || hex.length() < 1) {
            return null;
        }
        if (hex.equalsIgnoreCase("null")) {
            return null;
        }
        long value = 0L;
        int len = hex.length();
        for (int c = 0; c < len; ++c) {
            int i = hexChars.indexOf(hex.charAt(c));
            if (i < 0) {
                throw new IllegalArgumentException("Invalid hex character: " + hex.charAt(c));
            }
            value = value << 4 | (long)i;
        }
        return Data.toLong((long)value);
    }

    protected String convertNumber2Hex(Number num) {
        if (num == null) {
            return "null";
        }
        long value = num.longValue();
        String rc = "";
        do {
            rc = hexChars.charAt((int)(value & 0xFL)) + rc;
            rc = hexChars.charAt((int)((value >>= 4) & 0xFL)) + rc;
        } while ((value >>= 4) != 0L);
        return rc;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return this.convertNumber2Hex((Number)value);
        }
        return "";
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (!(value instanceof Number)) {
            value = null;
        }
        if (value == null) {
            return "null";
        }
        Number num = (Number)value;
        return "new Number(" + this.convertNumber2Hex(num) + ")";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException("Hex-Value is read-only");
    }
}

