/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import java.awt.Insets;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;

public class InsetsPropertyEditor
extends PropertyEditorSupport {
    protected String convertInsets2Text(Insets i) {
        if (i == null) {
            return null;
        }
        return "" + i.top + "," + i.left + "," + i.bottom + "," + i.right;
    }

    protected Insets convertText2Insets(String s) {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("null")) {
            return null;
        }
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        int c = 0;
        StringTokenizer tok = new StringTokenizer(s, ",", false);
        while (tok.hasMoreElements()) {
            String sub = String.valueOf(tok.nextElement());
            int intValue = Integer.parseInt(sub.trim());
            switch (c) {
                case 0: {
                    top = intValue;
                    break;
                }
                case 1: {
                    left = intValue;
                    break;
                }
                case 2: {
                    bottom = intValue;
                    break;
                }
                case 3: {
                    right = intValue;
                }
            }
            ++c;
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof Insets) {
            return this.convertInsets2Text((Insets)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "" + value;
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (!(value instanceof Insets)) {
            value = null;
        }
        if (value == null) {
            return "null";
        }
        Insets p = (Insets)value;
        return "new java.awt.Insets(" + this.convertInsets2Text(p) + ")";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(this.convertText2Insets(text));
    }
}

