/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.model.AbstractBeanModel;
import com.spacekiller.util.beans.model.AbstractBeanTreeBranchNode;
import com.spacekiller.util.beans.model.BeanTreeModel;
import com.spacekiller.util.beans.model.BeanTreeNode;
import com.spacekiller.util.beans.model.BeanTreeRootNode;
import java.beans.FeatureDescriptor;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;

public abstract class AbstractBeanTreeModel
extends AbstractBeanModel
implements BeanTreeModel {
    public static final Enumeration LEAF_ENUMERATION = null;
    public static final Enumeration NONLEAF_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return true;
        }

        public Object nextElement() {
            return this;
        }
    };
    private AbstractBeanTreeBranchNode root;
    private EventListenerList listenerList = new EventListenerList();
    private FeatureDescriptorFilter featureFilter;
    private static final Logger logger = Logger.getLogger(AbstractBeanTreeModel.class.getName());

    public AbstractBeanTreeModel(BeansToolkit tk, FeatureDescriptorFilter newFeatureFilter) {
        super(tk);
        this.root = this.createRootNode();
        this.setFeatureFilter(newFeatureFilter);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void beanStructureDeleted(BeanTreeNode parent, BeanTreeNode node) {
        if (node != null) {
            this.installBeanStructurePropertyChangeListener(node, false);
        }
    }

    @Override
    public void beanStructureInserted(BeanTreeNode parent, BeanTreeNode node) {
        if (node != null) {
            this.installBeanStructurePropertyChangeListener(node, true);
        }
    }

    @Override
    public void beanStructureUpdated(BeanTreeNode parent, BeanTreeNode oldNode, BeanTreeNode newNode) {
        if (oldNode != null) {
            this.installBeanStructurePropertyChangeListener(oldNode, false);
        }
        if (newNode != null) {
            this.installBeanStructurePropertyChangeListener(newNode, true);
        }
    }

    protected abstract BeanTreeNode createBeanTreeNode(Object var1);

    protected abstract Enumeration createChildNodes(Object var1, FeatureDescriptor var2, boolean var3);

    protected AbstractBeanTreeBranchNode createRootNode() {
        return new BeanTreeRootNode(this, null, null);
    }

    @Override
    protected void fireBeansDeleted(int firstIndex, int lastIndex) {
        for (int i = lastIndex; i >= firstIndex; --i) {
            this.root.removeChildNodeAt(i);
        }
        this.nodeStructureChanged(this.root);
    }

    @Override
    protected void fireBeansInserted(int firstIndex, int lastIndex) {
        logger.fine("fireBeansInserted: " + firstIndex + "-" + lastIndex);
        for (int i = firstIndex; i <= lastIndex; ++i) {
            this.root.insertChildNodeAt(this.createBeanTreeNode(this.getBeanAt(i)), i);
        }
        this.nodeStructureChanged(this.root);
    }

    @Override
    protected void fireBeansUpdated(int firstIndex, int lastIndex) {
        for (int i = firstIndex; i <= lastIndex; ++i) {
            this.root.setChildNodeAt(this.createBeanTreeNode(this.getBeanAt(i)), i);
        }
        this.nodeStructureChanged(this.root);
    }

    protected final void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeNodesChanged(e);
        }
    }

    protected final void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        logger.fine("fireTreeNodeInserted: " + childIndices.length);
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeNodesInserted(e);
        }
    }

    protected final void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeNodesRemoved(e);
        }
    }

    protected final void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeStructureChanged(e);
        }
    }

    @Override
    public Enumeration getChildNodes(BeanTreeNode forNode) {
        if (forNode == null) {
            return null;
        }
        if (forNode.isLoaded()) {
            return forNode.children();
        }
        Object bean = forNode.getBean();
        FeatureDescriptor feature = forNode.getFeatureDescriptor();
        return this.createChildNodes(bean, feature, false);
    }

    protected FeatureDescriptorFilter getFeatureFilter() {
        return this.featureFilter;
    }

    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    @Override
    public BeanTreeNode getRootNode() {
        return this.root;
    }

    @Override
    public boolean hasChildNodes(BeanTreeNode parent) {
        FeatureDescriptor feature;
        Object bean = parent.getBean();
        Enumeration en = this.createChildNodes(bean, feature = parent.getFeatureDescriptor(), true);
        boolean rc = en == null ? false : en.hasMoreElements();
        return rc;
    }

    protected void installBeanStructurePropertyChangeListener(BeanTreeNode node, boolean install) {
        if (install) {
            node.installPropertyChangeListener(this.getToolkit());
        } else {
            node.uninstallPropertyChangeListener(this.getToolkit());
        }
        if (node.isLoaded()) {
            int count = node.getChildCount();
            for (int c = 0; c < count; ++c) {
                this.installBeanStructurePropertyChangeListener((BeanTreeNode)node.getChildAt(c), install);
            }
        }
    }

    public void nodeChanged(TreeNode node) {
        if (this.listenerList != null && node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void setFeatureFilter(FeatureDescriptorFilter newFeatureFilter) {
        this.featureFilter = newFeatureFilter;
    }
}

