/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.model.AbstractBeanModel;
import java.beans.PropertyChangeEvent;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultBeanListModel
extends AbstractBeanModel
implements ListModel {
    private EventListenerList listenerList = new EventListenerList();

    public DefaultBeanListModel(BeansToolkit tk) {
        super(tk);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    protected void fireBeansDeleted(int firstIndex, int lastIndex) {
        this.fireIntervalRemoved(this, firstIndex, lastIndex);
    }

    @Override
    protected void fireBeansInserted(int firstIndex, int lastIndex) {
        this.fireIntervalAdded(this, firstIndex, lastIndex);
    }

    @Override
    protected void fireBeansUpdated(int firstIndex, int lastIndex) {
        this.fireContentsChanged(this, firstIndex, lastIndex);
    }

    protected final void fireContentsChanged(Object source, int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 0, index0, index1);
            }
            ((ListDataListener)listeners[i]).contentsChanged(e);
        }
    }

    protected final void fireIntervalAdded(Object source, int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 1, index0, index1);
            }
            ((ListDataListener)listeners[i]).contentsChanged(e);
        }
    }

    protected final void fireIntervalRemoved(Object source, int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 2, index0, index1);
            }
            ((ListDataListener)listeners[i]).contentsChanged(e);
        }
    }

    public Object getElementAt(int index) {
        return this.getBeanAt(index);
    }

    @Override
    public int getSize() {
        return this.getBeanCount();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int i;
        Object bean = evt.getSource();
        if (bean == null) {
            return;
        }
        int from = 0;
        while ((i = this.getBeanIndex(bean, from)) >= 0) {
            this.fireContentsChanged(this, i, i);
            from = i + 1;
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }
}

